/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class DutchNumber
extends SpokenNumber {
    private static final String[][] field = new String[][]{{"\u00e9\u00e9n", "twee", "drie", "vier", "vijf", "zes", "zeven", "acht", "negen"}, {"elf", "twaalf", "dertien", "veertien", "vijftien", "zestien", "zeventien", "achttien", "negentien"}, {"tien", "twintig", "dertig", "veertig", "vijftig", "zestig", "zeventig", "tachtig", "negentig"}};
    private static final String[][] amount = new String[][]{{"duizend", "duizend"}, {"miljoen", "miljoen"}};
    private static final String NULL = "nul";
    private static final String MINUS = "minus";
    private static final String EINS = "\u00e9\u00e9n";
    private static final String EINE = "\u00e9\u00e9n";
    private static final String EIN = "";
    private static final String UND = "en";
    private static final String HUNDERT = "honderd";
    protected String[] _1to9 = new String[]{"\u00e9\u00e9n", "twee", "drie", "vier", "vijf", "zes", "zeven", "acht", "negen"};

    public DutchNumber() {
    }

    public DutchNumber(long number) throws Exception {
        super(number);
    }

    public DutchNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 9;
    }

    @Override
    public String getSoundDir() {
        return "dutch";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add(MINUS);
        }
        if (this.numberType == 0) {
            this.number2digits();
            if (this.number.equalsIgnoreCase("0")) {
                this.syllables.add(NULL);
            } else {
                int counter = amount.length - 1;
                for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                    this.xtriple(i, i == 3 ? EIN : "\u00e9\u00e9n", amount[counter][0], amount[counter][1]);
                    --counter;
                }
                this.triple(0, "\u00e9\u00e9n");
            }
        } else if (this.numberType == 1) {
            this.fillSyllables(NULL, this._1to9);
        }
    }

    private void triple(int index, String smallestNumber) {
        if (this.digits[index + 2] > 0) {
            if (this.digits[index + 2] - 1 > 0) {
                this.syllables.add(field[0][this.digits[index + 2] - 1]);
            }
            this.syllables.add(HUNDERT);
            if (this.digits[index + 1] == 0 && this.digits[index] == 1) {
                this.syllables.add(UND);
            }
        }
        if (this.digits[index + 1] == 0 && this.digits[index] == 1) {
            this.syllables.add(smallestNumber);
        } else if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] == 1 && this.digits[index] == 0) {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
        } else if (this.digits[index + 1] != 1) {
            if (this.digits[index + 0] > 0) {
                this.syllables.add(field[0][this.digits[index] - 1]);
            }
            if (this.digits[index + 1] > 0) {
                if (this.digits[index + 0] > 0) {
                    this.syllables.add(UND);
                }
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
            }
        }
    }

    private void xtriple(int index, String minimum, String singular, String plural) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            this.triple(index, minimum);
            int sum = this.digits[index] + this.digits[index + 1] * 10 + this.digits[index + 2] * 100;
            if (sum >= 2) {
                this.syllables.add(plural);
            } else {
                this.syllables.add(singular);
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new DutchNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new DutchNumber(number).toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.syllables.size(); ++i) {
            sb.append(((String)this.syllables.get(i)).toString());
            sb.append(" ");
        }
        return sb.toString().trim();
    }
}

