/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class FinnishNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"yksi", "kaksi", "kolme", "nelj\u00e4", "viisi", "kuusi", "seitsem\u00e4n", "kahdeksan", "yhdeks\u00e4n"};
    private static final String NULL = "nolla";
    private static final String MINUS = "miinus";

    public FinnishNumber() {
    }

    public FinnishNumber(long number) throws Exception {
        super(number);
    }

    public FinnishNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 1;
    }

    @Override
    public String getSoundDir() {
        return "finnish";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("miinus ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            this.syllables.add(field[this.digits[0] - 1]);
        }
    }

    public static String toString(long number) throws Exception {
        return new FinnishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new FinnishNumber(number).toString();
    }
}

