/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class IndianHindiNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"\u0936\u0942\u0928\u094d\u092f", "\u090f\u0915", "\u0926\u094b", "\u0924\u0940\u0928", "\u091a\u093e\u0930", "\u092a\u093e\u0901\u091a", "\u091b\u0939", "\u0938\u093e\u0924", "\u0906\u0920", "\u0928\u094c", "\u0926\u0938", "\u0917\u094d\u092f\u093e\u0930\u0939", "\u092c\u093e\u0930\u0939", "\u0924\u0947\u0930\u0939", "\u091a\u094c\u0926\u0939", "\u092a\u0928\u094d\u0926\u094d\u0930\u0939", "\u0938\u094b\u0932\u0939", "\u0938\u0924\u094d\u0930\u0939", "\u0905\u0920\u093e\u0930\u0939", "\u0909\u0928\u094d\u0928\u0940\u0938", "\u092c\u0940\u0938", "\u0907\u0915\u094d\u0915\u0940\u0938", "\u092c\u093e\u0908\u0938", "\u0924\u0947\u0908\u0938", "\u091a\u094c\u092c\u0940\u0938", "\u092a\u091a\u094d\u091a\u0940\u0938", "\u091b\u092c\u094d\u092c\u0940\u0938", "\u0938\u0924\u094d\u0924\u093e\u0908\u0938", "\u0905\u091f\u094d\u0920\u093e\u0908\u0938", "\u0909\u0928\u0924\u0940\u0938", "\u0924\u0940\u0938", "\u0907\u0915\u0924\u0940\u0938", "\u092c\u0924\u094d\u0924\u0940\u0938", "\u0924\u0948\u0902\u0924\u0940\u0938", "\u091a\u094c\u0902\u0924\u0940\u0938", "\u092a\u0948\u0902\u0924\u0940\u0938", "\u091b\u0924\u094d\u0924\u0940\u0938", "\u0938\u0948\u0902\u0924\u0940\u0938", "\u0905\u0921\u093c\u0924\u0940\u0938", "\u0909\u0928\u0924\u093e\u0932\u0940\u0938", "\u091a\u093e\u0932\u0940\u0938", "\u0907\u0915\u0924\u093e\u0932\u0940\u0938", "\u092c\u092f\u093e\u0932\u0940\u0938", "\u0924\u0948\u0902\u0924\u093e\u0932\u0940\u0938", "\u091a\u094c\u0935\u093e\u0932\u0940\u0938", "\u092a\u0948\u0902\u0924\u093e\u0932\u0940\u0938", "\u091b\u093f\u092f\u093e\u0932\u0940\u0938", "\u0938\u0948\u0902\u0924\u093e\u0932\u0940\u0938", "\u0905\u0921\u093c\u0924\u093e\u0932\u0940\u0938", "\u0909\u0928\u091a\u093e\u0938", "\u092a\u091a\u093e\u0938", "\u0907\u0915\u094d\u092f\u093e\u0935\u0928", "\u092c\u093e\u0935\u0928", "\u0924\u093f\u0930\u0947\u092a\u0928", "\u091a\u094c\u0935\u0928", "\u092a\u091a\u092a\u0928", "\u091b\u092a\u094d\u092a\u0928", "\u0938\u0924\u094d\u0924\u093e\u0935\u0928", "\u0905\u091f\u094d\u0920\u093e\u0935\u0928", "\u0909\u0928\u0938\u0920", "\u0938\u093e\u0920", "\u0907\u0915\u0938\u0920", "\u092c\u093e\u0938\u0920", "\u0924\u093f\u0930\u0947\u0938\u0920", "\u091a\u094c\u0902\u0938\u0920", "\u092a\u0948\u0902\u0938\u0920", "\u091b\u093f\u092f\u093e\u0938\u0920", "\u0938\u0921\u093c\u0938\u0920", "\u0905\u0921\u093c\u0938\u0920", "\u0909\u0928\u0939\u0924\u094d\u0924\u0930", "\u0938\u0924\u094d\u0924\u0930", "\u0907\u0915\u0939\u0924\u094d\u0924\u0930", "\u092c\u0939\u0924\u094d\u0924\u0930", "\u0924\u093f\u0939\u0924\u094d\u0924\u0930", "\u091a\u094c\u0939\u0924\u094d\u0924\u0930", "\u092a\u091a\u0939\u0924\u094d\u0924\u0930", "\u091b\u093f\u0939\u0924\u094d\u0924\u0930", "\u0938\u0924\u0939\u0924\u094d\u0924\u0930", "\u0905\u0920\u0939\u0924\u094d\u0924\u0930", "\u0909\u0928\u093e\u0938\u0940", "\u0905\u0938\u094d\u0938\u0940", "\u0907\u0915\u094d\u092f\u093e\u0938\u0940", "\u092c\u092f\u093e\u0938\u0940", "\u0924\u093f\u0930\u093e\u0938\u0940", "\u091a\u094c\u0930\u093e\u0938\u0940", "\u092a\u091a\u093e\u0938\u0940", "\u091b\u093f\u092f\u093e\u0938\u0940", "\u0938\u0924\u094d\u0924\u093e\u0938\u0940", "\u0905\u091f\u094d\u0920\u093e\u0938\u0940", "\u0928\u0935\u093e\u0938\u0940", "\u0928\u092c\u094d\u092c\u0947", "\u0907\u0915\u094d\u092f\u093e\u0928\u092c\u0947", "\u092c\u093e\u0928\u092c\u0947", "\u0924\u093f\u0930\u093e\u0928\u092c\u0947", "\u091a\u094c\u0930\u093e\u0928\u092c\u0947", "\u092a\u0902\u091a\u093e\u0928\u092c\u0947", "\u091b\u093f\u092f\u093e\u0928\u092c\u0947", "\u0938\u0924\u094d\u0924\u093e\u0928\u092c\u0947", "\u0905\u091f\u094d\u0920\u093e\u0928\u092c\u0947", "\u0928\u093f\u0928\u094d\u092f\u093e\u0928\u092c\u0947"};
    private static final String[] transliteration = new String[]{"\u015bunya", "\u0113k", "do", "t\u012bn", "ch\u0101r", "p\u0101nch", "chah", "s\u0101at", "\u0101at", "nau", "das", "gy\u0101rah", "b\u0101rah", "t\u0113rah", "chaudah", "pandrah", "solah", "satrah", "atth\u0101rah", "unnis", "b\u012bs", "ikk\u012bsa", "b\u0101\u012bsa", "t\u0113\u012bsa", "chaub\u012bsa", "pachch\u012bsa", "chabb\u012bsa", "satt\u0101\u012bsa", "atth\u0101\u012bsa", "unat\u012bsa", "t\u012bsa", "ikat\u012bsa", "batt\u012bsa", "taimt\u012bsa", "chaumt\u012bsa", "paimt\u012bsa", "chatt\u012bsa", "saimt\u012bsa", "arat\u012bsa", "unch\u0101l\u012bsa", "ch\u0101l\u012bsa", "ikat\u0101l\u012bsa", "bay\u0101l\u012bsa", "taimt\u0101l\u012bsa", "chaumt\u0101l\u012bsa", "paimt\u0101l\u012bsa", "chiy\u0101l\u012bsa", "saimt\u0101l\u012bsa", "arat\u0101l\u012bsa", "unac\u0101sa", "pac\u0101sa", "iky\u0101bana", "b\u0101vana", "tir\u0113pana", "chaubana", "pachapana", "chappana", "satt\u0101vana", "atth\u0101vana", "unasatha", "s\u0101tha", "ikasatha", "b\u0101satha", "tirasatha", "chaumsatha", "paimsatha", "chiy\u0101satha", "sarasatha", "arasatha", "unahattara", "sattara", "ikahattara", "bahattara", "tihattara", "chauhattara", "pachahattara", "chihattara", "satahattara", "athahattara", "un\u0101s\u012b", "ass\u012b", "iky\u0101s\u012b", "bay\u0101s\u012b", "tir\u0101s\u012b", "chaur\u0101s\u012b", "pach\u0101s\u012b", "chiy\u0101s\u012b", "sat\u0101s\u012b", "ath\u0101s\u012b", "nav\u0101s\u012b", "nabb\u0113", "iky\u0101nab\u0113", "b\u0101nav\u0113", "tir\u0101nav\u0113", "chaur\u0101nav\u0113", "pach\u0101nav\u0113", "chiy\u0101nav\u0113", "satt\u0101nav\u0113", "atth\u0101nav\u0113", "niny\u0101nav\u0113"};
    private static final String MINUS = "-";
    private int index = 0;

    public IndianHindiNumber() {
    }

    public IndianHindiNumber(long number) throws Exception {
        super(number);
    }

    public IndianHindiNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 2;
    }

    @Override
    public String getSoundDir() {
        return "hindi";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("- ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(field);
            return;
        }
        this.number2digits();
        this.index = this.digits[1] * 10 + this.digits[0];
        this.syllables.add(field[this.index]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.syllables.size(); ++i) {
            sb.append(((String)this.syllables.get(i)).toString());
            if (this.numberType != 1 || !this.appendBlank) continue;
            sb.append(" ");
        }
        if (this.numberType != 1) {
            sb.append(" (");
            sb.append(transliteration[this.index]);
            sb.append(")");
        }
        return sb.toString().trim();
    }

    public static String toString(long number) throws Exception {
        return new IndianHindiNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new IndianHindiNumber(number).toString();
    }
}

