/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class JapaneseNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"rei", "ichi", "ni", "san", "yon", "go", "roku", "nana", "hachi", "ky\u00fb", "j\u00fb"};
    private static final String AND = "";
    private static final String MUL = "";
    private static final String MINUS = "-";

    public JapaneseNumber() {
    }

    public JapaneseNumber(long number) throws Exception {
        super(number);
    }

    public JapaneseNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 2;
    }

    @Override
    public String getSoundDir() {
        return "japanese";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("- ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(field);
            return;
        }
        this.number2digits();
        this.decode(0);
    }

    private void decode(int index) {
        int x = this.digits[index + 1] * 10 + this.digits[index];
        if (x < 11) {
            this.syllables.add(field[x]);
        } else {
            if (this.digits[index + 1] > 1) {
                this.syllables.add(field[this.digits[index + 1]] + "" + field[10]);
            } else {
                this.syllables.add(field[10]);
            }
            if (this.digits[index] > 0) {
                this.syllables.add("" + field[this.digits[index]]);
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new JapaneseNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new JapaneseNumber(number).toString();
    }
}

