/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class LatinNumber
extends SpokenNumber {
    private static final String[][] field = new String[][]{{"unus", "duo", "tres", "quattuor", "quinque", "sex", "septem", "octo", "novem"}, {"undecim", "duodecim", "tredecim", "quattuordecim", "quindecim", "sedecim", "septendecim", "duodeviginti", "undeviginti"}, {"decem", "viginti", "triginta", "quadraginta", "quinquaginta", "sexaginta", "septuaginta", "octoginta", "nonaginta"}};
    private static final String NULL = "nihil";
    private static final String MINUS = "-";

    public LatinNumber() {
    }

    public LatinNumber(long number) throws Exception {
        super(number);
    }

    public LatinNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 2;
    }

    @Override
    public String getSoundDir() {
        return "latin";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("- ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
            return;
        }
        this.number2digits();
        if (this.number.equalsIgnoreCase("0")) {
            this.syllables.add(NULL);
        } else {
            this.decode(0);
        }
    }

    private void decode(int index) {
        int x = this.digits[index + 1] * 10 + this.digits[index];
        if (x < 10) {
            this.syllables.add(field[0][x - 1]);
        } else if (x > 10 && x < 20) {
            this.syllables.add(field[1][x - 11]);
        } else {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
            if (this.digits[index] > 0) {
                this.syllables.add(" " + field[0][this.digits[index] - 1]);
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new LatinNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new LatinNumber(number).toString();
    }
}

