/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class PortugueseBrazilNumber
extends SpokenNumber {
    protected static final String[] line1 = new String[]{"um ", "dois ", "tr\u00eas ", "quatro ", "cinco ", "seis ", "sete ", "oito ", "nove "};
    protected static final String[] line2 = new String[]{"onze ", "doze ", "treze ", "quatorze ", "quinze ", "dezesseis ", "dezessete ", "dezoito ", "dezenove "};
    protected static final String[] line3 = new String[]{"dez ", "vinte ", "trinta ", "quarenta ", "cinq\u00fcenta ", "sessenta ", "setenta ", "oitenta ", "noventa "};
    protected static final String[] line4 = new String[]{"cento ", "duzentos ", "trezentos ", "quatrocentos ", "quinhentos ", "seiscentos ", "setecentos ", "oitocentos ", "novecentos "};
    private static final String[][] fieldfix = new String[][]{line1, line2, line3, line4};
    protected String[][] field = fieldfix;
    protected static final String[][] amount = new String[][]{{"mil ", "mil "}, {"milh\u00e3o ", "milh\u00f5es "}, {"bilh\u00e3o ", "bilh\u00f5es "}, {"trilh\u00e3o ", "trilh\u00f5es "}, {"quatrilh\u00e3o ", "quatrilh\u00f5es "}, {"quintilh\u00e3o ", "quintilh\u00f5es "}, {"sextilh\u00e3o ", "sextilh\u00f5es "}, {"setilh\u00e3o ", "setilh\u00f5es "}, {"octilh\u00e3o ", "octilh\u00f5es "}, {"nonilh\u00e3o ", "nonilh\u00f5es "}, {"decilh\u00e3o ", "decilh\u00f5es "}};
    protected static final String NULL = "zero";
    protected static final String MINUS = "menos ";
    protected static final String AND = "e ";
    protected static final String HUNDERT = "cem ";
    protected boolean setprefix = false;

    public PortugueseBrazilNumber() {
        this.appendBlank = false;
    }

    public PortugueseBrazilNumber(long number) throws Exception {
        super(number);
        this.appendBlank = false;
    }

    public PortugueseBrazilNumber(String number) throws Exception {
        super(number);
        this.appendBlank = false;
    }

    @Override
    protected int getSupportedDigits() {
        return 36;
    }

    @Override
    public String getSoundDir() {
        return "portuguese_br";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        this.setprefix = false;
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add(MINUS);
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, line1);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            int counter = amount.length - 1;
            for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                this.xtriple(i, amount[counter][0], amount[counter][1]);
                --counter;
            }
            this.xtriple(0, null, null);
        }
    }

    protected void triple(int index) {
        if (this.digits[index + 2] > 0) {
            if (this.digits[index + 2] == 1 && this.digits[index + 1] == 0 && this.digits[index] == 0) {
                this.syllables.add(HUNDERT);
            } else {
                this.syllables.add(this.field[3][this.digits[index + 2] - 1]);
                if (this.digits[index] + this.digits[index + 1] != 0) {
                    this.syllables.add(AND);
                }
            }
        }
        if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(this.field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] >= 1 && this.digits[index] == 0) {
            this.syllables.add(this.field[2][this.digits[index + 1] - 1]);
        } else {
            if (this.digits[index + 1] > 0) {
                this.syllables.add(this.field[2][this.digits[index + 1] - 1]);
                if (this.digits[index] > 0) {
                    this.syllables.add(AND);
                }
            }
            if (this.digits[index] > 0) {
                this.syllables.add(this.field[0][this.digits[index] - 1]);
            }
        }
    }

    protected boolean onlyZeros(int index) {
        boolean onlyZeros = true;
        for (int i = 0; i <= index; ++i) {
            if (this.digits[i] <= 0) continue;
            onlyZeros = false;
            break;
        }
        return onlyZeros;
    }

    protected void xtriple(int index, String singular, String plural) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            int sum;
            if (this.setprefix && (this.digits[index + 2] == 0 || this.digits[index] == 0 && this.digits[index + 1] == 0) && this.onlyZeros(index - 1)) {
                this.syllables.add(AND);
            }
            if ((sum = this.digits[index] + this.digits[index + 1] * 10 + this.digits[index + 2] * 100) != 1 || index != 3) {
                this.triple(index);
            }
            this.setprefix = true;
            if (index != 0) {
                if (sum > 1) {
                    this.syllables.add(plural);
                } else {
                    this.syllables.add(singular);
                }
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new PortugueseBrazilNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new PortugueseBrazilNumber(number).toString();
    }
}

