/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class RussianNumber
extends SpokenNumber {
    private static final String postfix1 = "\u043d\u0430\u0434\u0446\u0430\u0442\u044c";
    private static final String postfix2 = "\u0434\u0435\u0441\u044f\u0442";
    private static final String[][] field = new String[][]{{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044c\u0456\u0440\u0435", "\u043f\u044f\u0442\u044c", "\u0448\u0435\u0441\u0442\u044c", "\u0441\u0435\u043c\u044c", "\u0432\u043e\u0441\u0435\u043c\u044c", "\u0434\u0435\u0432\u044f\u0442\u044c"}, {"\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0447\u0435\u0442\u044c\u0456\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c"}, {"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e"}};
    private static final String NULL = "\u043d\u043e\u043b\u044c";
    private static final String MINUS = "\u043c\u0438\u043d\u0443\u0441";

    public RussianNumber() {
    }

    public RussianNumber(long number) throws Exception {
        super(number);
    }

    public RussianNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 2;
    }

    @Override
    public String getSoundDir() {
        return "russian";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("\u043c\u0438\u043d\u0443\u0441 ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            this.decode(0);
        }
    }

    private void decode(int index) {
        int x = this.digits[index + 1] * 10 + this.digits[index];
        if (x < 10) {
            this.syllables.add(field[0][x - 1]);
        } else if (x > 10 && x < 20) {
            this.syllables.add(field[1][x - 11]);
        } else {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
            if (this.digits[index] > 0) {
                this.syllables.add(" " + field[0][this.digits[index] - 1]);
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new RussianNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new RussianNumber(number).toString();
    }
}

