/* fi/joensuu/joyds1/calendar/test/First.java
   Copyright (C) 2009 Hannu Väisänen
 
This library is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
  
This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this library; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination. */

#include <iostream>
#include <unistd.h>
#include <gsl/gsl_multifit.h>


using namespace std;

// java C >foo
// gawk '{print $2, $3, $4, $5, $7}' foo >gsl.dat
// g++ -g gsl.cc -lgsl -lgslcblas -o g


static double f (gsl_vector *c, gsl_matrix *x, size_t n)
{
  double s = 0;
  for (size_t i = 0; i < c->size; i++) {
    s += gsl_vector_get(c,i) * gsl_matrix_get(x,n,i);
  }
  return round(s);
}


int main (int argc, char *argv[])
{
  bool print_coefficients = false;

  opterr = 0;
  int ch;

  while ((ch = getopt (argc, argv, "c")) != -1) {
    switch (ch) {
      case 'c':
        print_coefficients = true;
        break;
    }
  }

  const size_t N = 254553;
  const size_t M = 5;

  double cycle, year, month, day, jday;
  double ei, chisq;

  gsl_matrix *X = gsl_matrix_alloc (N, M);
  gsl_vector *y = gsl_vector_alloc (N);
  gsl_vector *c = gsl_vector_alloc (M);

  gsl_matrix *cov = gsl_matrix_alloc (M, M);

  for (size_t i = 0; i < N; i++) {
    if (fscanf (stdin, "%lf %lf %lf %lf %lf", &cycle, &year, &month, &day, &jday) != 5) {
      std::cout << "Oops!" << std::endl;
      exit (1);
    }

#if 1
//    std::cout << cycle << " " << year << " " << month << " "
//              << day << " " << jday << std::endl;
    gsl_matrix_set (X, i, 0, 1.0);
    gsl_matrix_set (X, i, 1, cycle);
    gsl_matrix_set (X, i, 2, year);
    gsl_matrix_set (X, i, 3, month);
    gsl_matrix_set (X, i, 4, day);
#else
    gsl_matrix_set (X, i, 0, cycle);
    gsl_matrix_set (X, i, 1, year);
    gsl_matrix_set (X, i, 2, month);
    gsl_matrix_set (X, i, 3, day);
#endif
    gsl_vector_set (y, i, jday);
  }

  {
    gsl_multifit_linear_workspace *work =
      gsl_multifit_linear_alloc (N, M);
    gsl_multifit_linear (X, y, c, cov, &chisq, work);
    gsl_multifit_linear_free (work);
  }


  if (print_coefficients) {
    for (size_t i = 0; i < M; i++) {
//      std::cout << i << " " << gsl_vector_get(c,i) << std::endl;
      printf ("c%d = %f\n", i, gsl_vector_get(c,i));
    }
  }
  else {
    for (size_t i = 0; i < N; i++) {
      const double est = f (c, X, i);
      std::cout // << gsl_matrix_get (X, i, 0) << " "
                << gsl_matrix_get (X, i, 1) << " "
                << gsl_matrix_get (X, i, 2) << " "
                << gsl_matrix_get (X, i, 3) << " "
                << gsl_matrix_get (X, i, 4) << " "
                << gsl_vector_get (y, i) << " "
                << est << " "
                << (est - gsl_vector_get (y, i))
                << std::endl;
    }
    return 0;
  }
}
