/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import jscicalc.Base;
import jscicalc.CalculatorApplet;
import jscicalc.HexPanel;
import jscicalc.PlainPanel;
import jscicalc.ShiftHexPanel;
import jscicalc.ShiftPanel;
import jscicalc.ShiftStatPanel;
import jscicalc.SpecialButtonType;
import jscicalc.StatPanel;
import jscicalc.button.AnsButton;
import jscicalc.button.BinButton;
import jscicalc.button.CalculatorButton;
import jscicalc.button.CopyButton;
import jscicalc.button.CplxButton;
import jscicalc.button.DecButton;
import jscicalc.button.DelButton;
import jscicalc.button.DownButton;
import jscicalc.button.EqualsButton;
import jscicalc.button.GraphButton;
import jscicalc.button.HexButton;
import jscicalc.button.InfoButton;
import jscicalc.button.LeftButton;
import jscicalc.button.MclButton;
import jscicalc.button.MminusButton;
import jscicalc.button.ModeButton;
import jscicalc.button.MplusButton;
import jscicalc.button.OctButton;
import jscicalc.button.OffButton;
import jscicalc.button.OnButton;
import jscicalc.button.OrigButton;
import jscicalc.button.PolButton;
import jscicalc.button.RCLButton;
import jscicalc.button.RightButton;
import jscicalc.button.STOButton;
import jscicalc.button.SciButton;
import jscicalc.button.SclButton;
import jscicalc.button.ShiftButton;
import jscicalc.button.SminusButton;
import jscicalc.button.SplusButton;
import jscicalc.button.UpButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalculatorPanel
extends JPanel
implements Runnable {
    private Base base;
    protected Color colour;
    private Spring xBorderSpring;
    private Spring yBorderSpring;
    private Spring strutX;
    private Spring strutY;
    private Spring minX;
    private Spring minY;
    private Spring buttonWidthSpring;
    private Spring narrowButtonWidthSpring;
    private Spring thinButtonWidthSpring;
    private Spring buttonHeightSpring;
    private Spring shortButtonHeightSpring;
    private Spring shortButtonWidthSpring;
    private Spring displayWidthSpring;
    private Spring displayHeightSpring;
    protected final CalculatorApplet applet;
    protected final SpecialButtonType sbt;
    protected SpringLayout layout;
    protected Vector<CalculatorButton> buttons;
    protected HashMap<Character, CalculatorButton> keyMap;

    public static CalculatorPanel createPanel(CalculatorApplet calculatorApplet, SpecialButtonType specialButtonType, Color color) {
        CalculatorPanel calculatorPanel = null;
        switch (specialButtonType) {
            case NONE: {
                calculatorPanel = new PlainPanel(calculatorApplet, specialButtonType, color);
                calculatorPanel.run();
                return calculatorPanel;
            }
            case SHIFT: {
                calculatorPanel = new ShiftPanel(calculatorApplet, specialButtonType, color);
                break;
            }
            case STAT: {
                calculatorPanel = new StatPanel(calculatorApplet, specialButtonType, color);
                break;
            }
            case SHIFT_STAT: {
                calculatorPanel = new ShiftStatPanel(calculatorApplet, specialButtonType, color);
                break;
            }
            case HEX: {
                calculatorPanel = new HexPanel(calculatorApplet, specialButtonType, color);
                break;
            }
            case SHIFT_HEX: {
                calculatorPanel = new ShiftHexPanel(calculatorApplet, specialButtonType, color);
                break;
            }
            default: {
                calculatorPanel = null;
            }
        }
        Thread thread = new Thread(calculatorPanel);
        thread.setPriority(1);
        thread.start();
        return calculatorPanel;
    }

    @Override
    public synchronized void run() {
        this.setUp();
    }

    protected CalculatorPanel(CalculatorApplet calculatorApplet, SpecialButtonType specialButtonType, Color color) {
        this.applet = calculatorApplet;
        this.sbt = specialButtonType;
        this.colour = color;
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.colour);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void setUp() {
        this.keyMap = new HashMap();
        this.layout = new SpringLayout();
        this.setLayout(this.layout);
        this.buttons = new Vector();
        for (int i = 0; i < 45; ++i) {
            CalculatorButton calculatorButton = null;
            if (i == 0) {
                calculatorButton = new OffButton(this.applet);
            } else if (i == 5) {
                calculatorButton = new ModeButton(this.applet);
            } else if (i == 10) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_STAT: 
                    case SHIFT_HEX: {
                        calculatorButton = new OrigButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new ShiftButton(this.applet);
                        break;
                    }
                }
            } else if (i == 14) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_STAT: 
                    case SHIFT_HEX: {
                        if (this.applet.getGraphical()) {
                            calculatorButton = new GraphButton(this.applet);
                            break;
                        }
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 15) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_STAT: 
                    case SHIFT_HEX: {
                        calculatorButton = new CopyButton(this.applet);
                        break;
                    }
                    case NONE: 
                    case STAT: 
                    case HEX: {
                        calculatorButton = new STOButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 16) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_STAT: 
                    case SHIFT_HEX: {
                        calculatorButton = new SciButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 20) {
                switch (this.sbt) {
                    case NONE: 
                    case STAT: 
                    case HEX: {
                        calculatorButton = new RCLButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 21) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_STAT: 
                    case SHIFT_HEX: {
                        calculatorButton = new PolButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 25) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_HEX: {
                        calculatorButton = new MminusButton(this.applet);
                        break;
                    }
                    case STAT: {
                        calculatorButton = new SplusButton(this.applet);
                        break;
                    }
                    case SHIFT_STAT: {
                        calculatorButton = new SminusButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new MplusButton(this.applet);
                        break;
                    }
                }
            } else if (i == 26) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_STAT: 
                    case SHIFT_HEX: {
                        calculatorButton = new CplxButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 30) {
                switch (this.sbt) {
                    case NONE: 
                    case STAT: 
                    case HEX: {
                        calculatorButton = new DelButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 32) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_HEX: {
                        calculatorButton = new HexButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 33) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_HEX: {
                        calculatorButton = new DecButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 34) {
                switch (this.sbt) {
                    case NONE: 
                    case STAT: 
                    case HEX: {
                        calculatorButton = new AnsButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 35) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_HEX: {
                        calculatorButton = new MclButton(this.applet);
                        break;
                    }
                    case SHIFT_STAT: {
                        calculatorButton = new SclButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new OnButton(this.applet);
                        break;
                    }
                }
            } else if (i == 37) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_HEX: {
                        calculatorButton = new BinButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 38) {
                switch (this.sbt) {
                    case SHIFT: 
                    case SHIFT_HEX: {
                        calculatorButton = new OctButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else if (i == 39) {
                switch (this.sbt) {
                    case NONE: 
                    case STAT: 
                    case HEX: {
                        calculatorButton = new EqualsButton(this.applet);
                        break;
                    }
                    default: {
                        calculatorButton = new CalculatorButton(this.applet);
                        break;
                    }
                }
            } else {
                calculatorButton = i == 40 ? new LeftButton(this.applet) : (i == 41 ? new RightButton(this.applet) : (i == 42 ? new InfoButton(this.applet) : (i == 43 ? new UpButton(this.applet) : (i == 44 ? new DownButton(this.applet) : new CalculatorButton(this.applet)))));
            }
            this.buttons.add(calculatorButton);
            this.add(calculatorButton);
        }
        this.setButtons();
        this.layoutSprings();
    }

    protected abstract void setButtons();

    public synchronized void layoutSprings() {
        this.xBorderSpring = Spring.constant(0, this.applet.strutSize(), Integer.MAX_VALUE);
        this.yBorderSpring = Spring.constant(0, this.applet.strutSize(), Integer.MAX_VALUE);
        this.strutX = Spring.constant(this.applet.strutSize());
        this.strutY = Spring.constant(this.applet.strutSize());
        this.minX = Spring.constant(this.applet.minSize());
        this.minY = Spring.constant(this.applet.minSize());
        this.buttonWidthSpring = Spring.constant(this.applet.buttonWidth());
        this.narrowButtonWidthSpring = Spring.constant(this.applet.buttonWidth() - this.applet.strutSize() * 2 - (this.applet.minSize() + this.applet.buttonHeight()) / 2);
        this.thinButtonWidthSpring = Spring.constant(this.applet.buttonHeight());
        this.buttonHeightSpring = Spring.constant(this.applet.buttonHeight());
        this.shortButtonHeightSpring = Spring.constant(this.applet.buttonHeight() - this.applet.minSize());
        int n = this.applet.buttonHeight();
        if ((this.applet.minSize() - n) % 2 != 0) {
            ++n;
        }
        int n2 = this.applet.buttonWidth() + (this.applet.minSize() - n) / 2;
        this.shortButtonWidthSpring = Spring.constant(n);
        this.displayWidthSpring = Spring.scale(this.buttonWidthSpring, 6.0f);
        this.displayWidthSpring = Spring.sum(this.displayWidthSpring, this.strutX);
        this.displayWidthSpring = Spring.sum(this.displayWidthSpring, Spring.scale(this.minX, 4.0f));
        this.displayHeightSpring = Spring.constant(this.applet.displayHeight());
        Spring spring = Spring.scale(this.xBorderSpring, 2.0f);
        spring = Spring.sum(spring, Spring.scale(this.buttonWidthSpring, 8.0f));
        spring = Spring.sum(spring, Spring.scale(this.strutX, 2.0f));
        spring = Spring.sum(spring, Spring.scale(this.minX, 5.0f));
        Spring spring2 = Spring.scale(this.yBorderSpring, 2.0f);
        spring2 = Spring.sum(spring2, this.displayHeightSpring);
        spring2 = Spring.sum(spring2, this.strutY);
        spring2 = Spring.sum(spring2, Spring.scale(this.buttonHeightSpring, 5.0f));
        spring2 = Spring.sum(spring2, Spring.scale(this.minY, 4.0f));
        SpringLayout.Constraints constraints = this.layout.getConstraints(this);
        constraints.setWidth(spring);
        constraints.setHeight(spring2);
        Spring spring3 = Spring.sum(this.xBorderSpring, Spring.sum(this.buttonWidthSpring, this.minX));
        Spring spring4 = Spring.sum(spring3, Spring.sum(this.buttonWidthSpring, this.minX));
        Spring spring5 = Spring.sum(spring4, Spring.sum(this.buttonWidthSpring, this.strutX));
        Spring spring6 = Spring.sum(spring5, Spring.sum(this.buttonWidthSpring, this.minX));
        Spring spring7 = Spring.sum(spring6, Spring.sum(this.buttonWidthSpring, this.minX));
        Spring spring8 = Spring.sum(spring7, Spring.sum(this.buttonWidthSpring, this.strutX));
        Spring spring9 = Spring.sum(spring8, Spring.sum(this.buttonWidthSpring, this.minX));
        Spring spring10 = Spring.sum(this.yBorderSpring, Spring.sum(this.displayHeightSpring, this.strutY));
        Spring spring11 = Spring.sum(spring10, Spring.sum(this.buttonHeightSpring, this.minY));
        Spring spring12 = Spring.sum(spring11, Spring.sum(this.buttonHeightSpring, this.minY));
        Spring spring13 = Spring.sum(spring12, Spring.sum(this.buttonHeightSpring, this.minY));
        Spring spring14 = Spring.sum(spring13, Spring.sum(this.buttonHeightSpring, this.minY));
        for (int i = 0; i < 40; ++i) {
            constraints = this.layout.getConstraints(this.buttons().elementAt(i));
            constraints.setWidth(this.buttonWidthSpring);
            constraints.setHeight(this.buttonHeightSpring);
            if (i < 5) {
                constraints.setX(this.xBorderSpring);
            } else if (i < 10) {
                constraints.setX(spring3);
            } else if (i < 15) {
                constraints.setX(spring4);
            } else if (i < 20) {
                constraints.setX(spring5);
            } else if (i < 25) {
                constraints.setX(spring6);
            } else if (i < 30) {
                constraints.setX(spring7);
            } else if (i < 35) {
                constraints.setX(spring8);
            } else {
                constraints.setX(spring9);
            }
            int n3 = i % 5;
            if (n3 == 0) {
                constraints.setY(spring10);
                continue;
            }
            if (n3 == 1) {
                constraints.setY(spring11);
                continue;
            }
            if (n3 == 2) {
                constraints.setY(spring12);
                continue;
            }
            if (n3 == 3) {
                constraints.setY(spring13);
                continue;
            }
            constraints.setY(spring14);
        }
        Spring spring15 = Spring.constant(this.applet.strutSize() + (this.applet.displayHeight() - this.applet.buttonHeight()) / 2);
        constraints = this.layout.getConstraints(this.buttons().elementAt(40));
        constraints.setWidth(this.narrowButtonWidthSpring);
        constraints.setHeight(this.buttonHeightSpring);
        Spring spring16 = Spring.sum(this.displayWidthSpring, Spring.scale(this.strutX, 4.0f));
        constraints.setX(spring16);
        constraints.setY(spring15);
        constraints = this.layout.getConstraints(this.buttons().elementAt(42));
        constraints.setWidth(this.thinButtonWidthSpring);
        constraints.setHeight(this.buttonHeightSpring);
        Spring spring17 = Spring.sum(spring16, Spring.sum(this.minX, this.narrowButtonWidthSpring));
        constraints.setX(spring17);
        constraints.setY(spring15);
        constraints = this.layout.getConstraints(this.buttons().elementAt(41));
        constraints.setWidth(this.narrowButtonWidthSpring);
        constraints.setHeight(this.buttonHeightSpring);
        Spring spring18 = Spring.sum(spring17, Spring.sum(this.minX, this.thinButtonWidthSpring));
        constraints.setX(spring18);
        constraints.setY(spring15);
        constraints = this.layout.getConstraints(this.buttons().elementAt(43));
        constraints.setWidth(this.shortButtonWidthSpring);
        constraints.setHeight(this.shortButtonHeightSpring);
        Spring spring19 = Spring.sum(Spring.constant(n2), Spring.sum(this.displayWidthSpring, Spring.scale(this.strutX, 2.0f)));
        constraints.setX(spring19);
        constraints.setY(this.strutY);
        constraints = this.layout.getConstraints(this.buttons().elementAt(44));
        constraints.setWidth(this.shortButtonWidthSpring);
        constraints.setHeight(this.shortButtonHeightSpring);
        constraints.setX(spring19);
        Spring spring20 = Spring.sum(Spring.scale(this.minY, 2.0f), Spring.sum(this.shortButtonHeightSpring, Spring.sum(this.buttonHeightSpring, this.strutY)));
        constraints.setY(spring20);
    }

    public synchronized void setDisplayPanel() {
        this.remove(this.applet.displayPanel());
        this.add(this.applet.displayPanel());
        SpringLayout.Constraints constraints = ((SpringLayout)this.getLayout()).getConstraints(this.applet.displayPanel());
        constraints = this.layout.getConstraints(this.applet.displayPanel());
        constraints.setX(this.xBorderSpring);
        constraints.setY(this.yBorderSpring);
        constraints.setWidth(this.displayWidthSpring);
        constraints.setHeight(this.displayHeightSpring);
    }

    public synchronized Vector<CalculatorButton> buttons() {
        return this.buttons;
    }

    public synchronized HashMap<Character, CalculatorButton> keyMap() {
        return this.keyMap;
    }

    protected void createKeyMap() {
        for (CalculatorButton calculatorButton : this.buttons) {
            if (calculatorButton.shortcut() == '\u0000') continue;
            if (this.keyMap.containsKey(Character.valueOf(calculatorButton.shortcut()))) {
                System.out.print("Repeat of ");
                System.out.print(calculatorButton.shortcut());
                System.out.print(" in ");
                System.out.println(calculatorButton.tooltip());
            }
            this.keyMap.put(Character.valueOf(calculatorButton.shortcut()), calculatorButton);
        }
    }

    public Base base() {
        return this.base;
    }

    public void base(Base base) {
        this.base = base;
    }
}

