/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import jscicalc.DisplayLabel;
import jscicalc.EntryLabel;
import jscicalc.ExtraPanel;
import jscicalc.LeftOrRight;
import jscicalc.MiniPanel;
import jscicalc.Parser;
import jscicalc.ReadOnlyCalculatorApplet;
import jscicalc.ReadOnlyDisplayPanel;
import jscicalc.ScrollableLabel;
import jscicalc.pobject.PObject;

public class DisplayPanel
extends JPanel
implements ReadOnlyDisplayPanel {
    private ScrollableLabel labelWithCaret;
    private EntryLabel entryLabel;
    private DisplayLabel displayLabel;
    private ExtraPanel extraPanel;
    private MiniPanel leftPanel;
    private MiniPanel rightPanel;
    private final ReadOnlyCalculatorApplet applet;
    private boolean on;
    private static final long serialVersionUID = 1L;

    public DisplayPanel(ReadOnlyCalculatorApplet readOnlyCalculatorApplet) {
        this.applet = readOnlyCalculatorApplet;
        this.entryLabel = new EntryLabel(this);
        this.displayLabel = new DisplayLabel(this);
        this.extraPanel = new ExtraPanel(this);
        this.leftPanel = new MiniPanel(true);
        this.rightPanel = new MiniPanel(false);
        this.add(this.entryLabel);
        this.add(this.displayLabel);
        this.setCaretToEntry();
        this.add(this.extraPanel);
        this.add(this.leftPanel);
        this.add(this.rightPanel);
    }

    public void setUp() {
        Insets insets = this.getInsets();
        int n = insets.bottom;
        int n2 = insets.left;
        int n3 = insets.right;
        int n4 = insets.top;
        int n5 = this.getApplet().strutSize() + 4 * this.getApplet().minSize() + 6 * this.getApplet().buttonWidth();
        int n6 = this.getApplet().displayHeight();
        int n7 = (int)(0.09 * (double)n5 + 0.5);
        int n8 = (int)(0.125 * (double)this.getApplet().extraTextSize() + 0.5);
        int n9 = 2 * n8;
        int n10 = (int)(0.58 * (double)(n6 - 3 * n8) + 0.5);
        int n11 = (int)(0.1 * (double)n10 + 0.5);
        Spring spring = Spring.constant(n8, n8, n8);
        Spring spring2 = Spring.sum(spring, spring);
        Spring spring3 = Spring.constant(n7);
        Spring spring4 = Spring.constant(n10);
        Spring spring5 = Spring.constant(n11);
        Spring spring6 = Spring.sum(spring5, spring2);
        Spring spring7 = Spring.constant(0, 0, 2);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        SpringLayout.Constraints constraints = null;
        constraints = springLayout.getConstraints(this.entryLabel);
        constraints.setWidth(Spring.constant(n5 - 2 * n9 - n11));
        constraints.setHeight(Spring.constant(n6 - 2 * n8 - n10 - n - n4));
        springLayout.putConstraint("North", (Component)this.entryLabel, spring, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.entryLabel, spring2, "West", (Component)this);
        springLayout.putConstraint("East", (Component)this.entryLabel, Spring.minus(spring6), "East", (Component)this);
        constraints = springLayout.getConstraints(this.extraPanel);
        constraints.setWidth(spring3);
        constraints.setHeight(spring4);
        springLayout.putConstraint("North", (Component)this.extraPanel, spring7, "South", (Component)this.entryLabel);
        springLayout.putConstraint("South", (Component)this.extraPanel, Spring.minus(spring), "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.extraPanel, spring2, "West", (Component)this);
        constraints = springLayout.getConstraints(this.leftPanel);
        constraints.setWidth(spring5);
        constraints.setHeight(spring4);
        springLayout.putConstraint("North", (Component)this.leftPanel, spring7, "South", (Component)this.entryLabel);
        springLayout.putConstraint("South", (Component)this.leftPanel, Spring.minus(spring), "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.leftPanel, spring7, "East", (Component)this.extraPanel);
        constraints = springLayout.getConstraints(this.displayLabel);
        constraints.setHeight(spring4);
        constraints.setWidth(Spring.constant(n5 - n7 - 2 * n11 - 2 * n9 - n2 - n3));
        springLayout.putConstraint("North", (Component)this.displayLabel, spring7, "South", (Component)this.entryLabel);
        springLayout.putConstraint("South", (Component)this.displayLabel, Spring.minus(spring), "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.displayLabel, spring7, "East", (Component)this.leftPanel);
        constraints = springLayout.getConstraints(this.displayLabel);
        constraints.setHeight(spring4);
        constraints = springLayout.getConstraints(this.rightPanel);
        constraints.setWidth(spring5);
        constraints.setHeight(spring4);
        springLayout.putConstraint("North", (Component)this.rightPanel, spring7, "South", (Component)this.entryLabel);
        springLayout.putConstraint("South", (Component)this.rightPanel, Spring.minus(spring), "South", (Component)this);
        springLayout.putConstraint("West", (Component)this.rightPanel, spring7, "East", (Component)this.displayLabel);
        springLayout.putConstraint("East", (Component)this.rightPanel, Spring.minus(spring2), "East", (Component)this);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void left() {
        this.labelWithCaret.left();
    }

    public void right() {
        this.labelWithCaret.right();
    }

    public void update(boolean bl, boolean bl2) {
        if (bl) {
            this.entryLabel.update(this.on);
        }
        this.displayLabel.update(this.on);
        this.extraPanel.repaint();
        LeftOrRight leftOrRight = LeftOrRight.NEITHER;
        if (this.displayLabelHasCaret()) {
            leftOrRight = this.displayLabel.getScrollDirections();
        }
        switch (leftOrRight) {
            case LEFT: {
                this.leftPanel.setIlluminated(true);
                this.rightPanel.setIlluminated(false);
                break;
            }
            case RIGHT: {
                this.leftPanel.setIlluminated(false);
                this.rightPanel.setIlluminated(true);
                break;
            }
            case BOTH: {
                this.leftPanel.setIlluminated(true);
                this.rightPanel.setIlluminated(true);
                break;
            }
            case NEITHER: {
                this.leftPanel.setIlluminated(false);
                this.rightPanel.setIlluminated(false);
                break;
            }
            default: {
                this.leftPanel.setIlluminated(false);
                this.rightPanel.setIlluminated(false);
            }
        }
        this.leftPanel.repaint();
        this.rightPanel.repaint();
    }

    final boolean displayLabelScrollable() {
        return this.displayLabel.getScrollDirections() != LeftOrRight.NEITHER;
    }

    public Action backward() {
        return this.entryLabel.backward();
    }

    public void setExpression(Parser parser) {
        this.entryLabel.setExpression(parser);
    }

    public void newExpression() {
        this.entryLabel.newExpression();
    }

    public void clear(Parser parser) {
        this.entryLabel.clear(parser);
    }

    public void delete(Parser parser) {
        this.entryLabel.delete(parser);
    }

    public void insert(PObject pObject, Parser parser) {
        this.entryLabel.insert(pObject, parser);
    }

    public void setOn(boolean bl) {
        this.on = bl;
    }

    public boolean getOn() {
        return this.on;
    }

    public void setValue() {
        this.displayLabel.setNewExpression();
    }

    public ReadOnlyCalculatorApplet getApplet() {
        return this.applet;
    }

    public final DisplayLabel getDisplayLabel() {
        return this.displayLabel;
    }

    public void setCaretToEntry() {
        this.labelWithCaret = this.entryLabel;
        this.displayLabel.updateCaretVisibility();
        this.entryLabel.updateCaretVisibility();
    }

    public void setCaretToDisplay() {
        this.labelWithCaret = this.displayLabel;
        this.entryLabel.updateCaretVisibility();
        this.displayLabel.updateCaretVisibility();
    }

    public boolean hasCaret(ScrollableLabel scrollableLabel) {
        return this.labelWithCaret == scrollableLabel;
    }

    public boolean displayLabelHasCaret() {
        return this.hasCaret(this.displayLabel);
    }
}

