/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import jscicalc.AngleType;
import jscicalc.Base;
import jscicalc.Error;
import jscicalc.GObject;
import jscicalc.OObject;
import jscicalc.ParseBase;
import jscicalc.complex.Complex;
import jscicalc.pobject.AFunction;
import jscicalc.pobject.Add;
import jscicalc.pobject.BoolFunction;
import jscicalc.pobject.Combination;
import jscicalc.pobject.Container;
import jscicalc.pobject.Cube;
import jscicalc.pobject.DFunction;
import jscicalc.pobject.E;
import jscicalc.pobject.I;
import jscicalc.pobject.LFunction;
import jscicalc.pobject.LParen;
import jscicalc.pobject.MFunction;
import jscicalc.pobject.Multiply;
import jscicalc.pobject.Numeral;
import jscicalc.pobject.PObject;
import jscicalc.pobject.RFunction;
import jscicalc.pobject.RParen;
import jscicalc.pobject.Subtract;
import jscicalc.pobject.Trig;
import jscicalc.pobject.Uminus;
import jscicalc.pobject.Uplus;
import jscicalc.pobject.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private LinkedList<GObject> list = new LinkedList();
    private Base base = Base.DECIMAL;

    private void convertExponentsToNumerals(List<GObject> list) {
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof E)) continue;
            listIterator.set(new Numeral('e'));
            boolean bl = false;
            gObject = listIterator.next();
            while (gObject instanceof Add || gObject instanceof Subtract) {
                if (gObject instanceof Subtract) {
                    bl = !bl;
                }
                listIterator.remove();
                gObject = listIterator.next();
            }
            listIterator.previous();
            if (!bl) continue;
            listIterator.previous();
            listIterator.next();
            listIterator.add(new Numeral('-'));
        }
    }

    private void convertNumerals(List<GObject> list) {
        this.convertExponentsToNumerals(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            boolean bl;
            GObject gObject = listIterator.next();
            if (!(gObject instanceof Numeral)) continue;
            listIterator.remove();
            Numeral numeral = (Numeral)gObject;
            String string = numeral.name();
            while ((bl = listIterator.hasNext()) && (gObject = listIterator.next()) instanceof Numeral) {
                listIterator.remove();
                numeral = (Numeral)gObject;
                string = string.concat(numeral.name());
            }
            if (bl) {
                listIterator.previous();
            }
            listIterator.add(ParseBase.parseString(string, this.base));
        }
    }

    private void convertContainers(List<GObject> list) {
        this.convertNumerals(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof Container)) continue;
            if (((Container)gObject).error()) {
                throw new RuntimeException("Stat Error");
            }
            listIterator.set(((Container)gObject).value());
        }
    }

    private void convertIs(List<GObject> list) {
        this.convertContainers(list);
        ListIterator<GObject> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof I)) continue;
            listIterator.set(Complex.I);
            if (listIterator.hasNext()) {
                gObject = listIterator.next();
                if (gObject instanceof I || gObject instanceof Complex) {
                    listIterator.previous();
                    listIterator.add(new Multiply());
                    listIterator.previous();
                } else {
                    listIterator.previous();
                }
            }
            listIterator.previous();
            if (!listIterator.hasPrevious() || !((gObject = listIterator.previous()) instanceof Complex)) continue;
            listIterator.next();
            listIterator.add(new Multiply());
            listIterator.next();
        }
    }

    private void convertVariables(List<GObject> list) {
        this.convertIs(list);
        ListIterator<GObject> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof Variable)) continue;
            listIterator.set(new jscicalc.expression.Variable((Variable)gObject));
            if (listIterator.hasNext()) {
                gObject = listIterator.next();
                if (gObject instanceof Complex || gObject instanceof Variable) {
                    listIterator.previous();
                    listIterator.add(new Multiply());
                    listIterator.previous();
                } else {
                    listIterator.previous();
                }
            }
            listIterator.previous();
            if (!listIterator.hasPrevious() || !((gObject = listIterator.previous()) instanceof Complex)) continue;
            listIterator.next();
            listIterator.add(new Multiply());
            listIterator.next();
        }
    }

    private void convertARFunctions(List<GObject> list) {
        this.convertVariables(list);
        ListIterator<GObject> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            GObject gObject = listIterator.previous();
            if (!(gObject instanceof AFunction)) continue;
            AFunction aFunction = (AFunction)gObject;
            boolean bl = !listIterator.hasPrevious();
            if (!bl && ((gObject = listIterator.previous()) instanceof OObject || gObject instanceof LFunction)) continue;
            if (!bl) {
                listIterator.next();
            }
            listIterator.next();
            if (aFunction instanceof Add) {
                listIterator.set(new Uplus());
                continue;
            }
            if (aFunction instanceof Subtract) {
                listIterator.set(new Uminus());
                continue;
            }
            throw new RuntimeException("+/- Error");
        }
    }

    private void convertLFunctions(List<GObject> list) {
        this.convertARFunctions(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof LFunction)) continue;
            listIterator.remove();
            LFunction lFunction = (LFunction)gObject;
            OObject oObject = (OObject)listIterator.previous();
            listIterator.set(lFunction.function(oObject));
        }
    }

    private void convertDFunctions(List<GObject> list) {
        this.convertLFunctions(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof DFunction)) continue;
            listIterator.remove();
            DFunction dFunction = (DFunction)gObject;
            gObject = listIterator.next();
            boolean bl = true;
            while (gObject instanceof Uplus || gObject instanceof Uminus) {
                bl ^= gObject instanceof Uminus;
                listIterator.remove();
                gObject = listIterator.next();
            }
            OObject oObject = (OObject)gObject;
            listIterator.remove();
            OObject oObject2 = (OObject)listIterator.previous();
            listIterator.set(bl ? dFunction.function(oObject2, oObject) : dFunction.function(oObject2, oObject.negate()));
        }
    }

    private void convertRFunctions(List<GObject> list) {
        this.convertDFunctions(list);
        ListIterator<GObject> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            GObject gObject = listIterator.previous();
            if (!(gObject instanceof RFunction)) continue;
            listIterator.remove();
            RFunction rFunction = (RFunction)gObject;
            OObject oObject = (OObject)listIterator.next();
            listIterator.set(rFunction.function(oObject));
        }
    }

    private void convertMFunctions(List<GObject> list) {
        this.convertRFunctions(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            OObject oObject;
            GObject gObject;
            GObject gObject2 = listIterator.next();
            if (gObject2 instanceof MFunction) {
                listIterator.remove();
                gObject = (MFunction)gObject2;
                oObject = (OObject)listIterator.next();
                listIterator.remove();
                OObject oObject2 = (OObject)listIterator.previous();
                listIterator.set(((MFunction)gObject).function(oObject2, oObject));
                continue;
            }
            if (!(gObject2 instanceof OObject)) continue;
            gObject = (OObject)gObject2;
            if (!listIterator.hasNext()) continue;
            gObject2 = listIterator.next();
            if (gObject2 instanceof OObject) {
                oObject = (OObject)gObject2;
                listIterator.set(((OObject)gObject).multiply(oObject));
                listIterator.previous();
                listIterator.previous();
                listIterator.remove();
                continue;
            }
            listIterator.previous();
        }
    }

    private void convertAFunctions(List<GObject> list) {
        this.convertMFunctions(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof AFunction)) continue;
            listIterator.remove();
            AFunction aFunction = (AFunction)gObject;
            OObject oObject = (OObject)listIterator.next();
            listIterator.remove();
            OObject oObject2 = (OObject)listIterator.previous();
            OObject oObject3 = aFunction.function(oObject2, oObject);
            listIterator.set(oObject3);
        }
    }

    private void convertBoolFunctions(List<GObject> list) {
        this.convertAFunctions(list);
        ListIterator<GObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GObject gObject = listIterator.next();
            if (!(gObject instanceof BoolFunction)) continue;
            listIterator.remove();
            BoolFunction boolFunction = (BoolFunction)gObject;
            OObject oObject = (OObject)listIterator.next();
            listIterator.remove();
            OObject oObject2 = (OObject)listIterator.previous();
            listIterator.set(boolFunction.function(oObject2, oObject));
        }
    }

    private void convertToProduct(List<GObject> list) {
        this.convertBoolFunctions(list);
        while (list.size() > 1) {
            OObject oObject = (OObject)list.get(0);
            OObject oObject2 = (OObject)list.remove(1);
            list.set(0, oObject2.multiply((OObject)list.get(0)));
        }
    }

    private boolean stripParenthesis(List<GObject> list) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            GObject gObject = list.get(i);
            if (gObject instanceof LParen) {
                n = i;
                continue;
            }
            if (!(gObject instanceof RParen)) continue;
            n2 = i;
            break;
        }
        if (n == -1 && n2 == -1) {
            return false;
        }
        if (n == -1 || n2 == -1) {
            throw new RuntimeException("Parenthesis Error");
        }
        list.remove(n2);
        list.remove(n);
        this.convertToProduct(list.subList(n, n2 - 1));
        return true;
    }

    public OObject evaluate(AngleType angleType) {
        for (GObject gObject : this.list) {
            if (!(gObject instanceof Trig)) continue;
            ((Trig)gObject).setScale(angleType);
        }
        try {
            while (this.stripParenthesis(this.list)) {
            }
            this.convertToProduct(this.list);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return new Error("Error");
        }
        if (this.list.size() != 1) {
            System.out.println(this.list.size());
            return new Error("Error");
        }
        try {
            OObject oObject = (OObject)this.list.remove(0);
            return oObject.auto_simplify();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return new Error("Error");
        }
    }

    public int size() {
        return this.list.size();
    }

    public void add(GObject gObject) {
        this.list.add(gObject);
    }

    public void add(int n, GObject gObject) {
        if (n < this.list.size()) {
            this.list.add(n, gObject);
        } else if (n == this.list.size()) {
            this.list.add(gObject);
        } else {
            throw new RuntimeException("Parser.add(): index out of range");
        }
    }

    public PObject del(int n) {
        if (n > 0 && n < this.list.size()) {
            GObject gObject = this.list.remove(n - 1);
            if (gObject instanceof PObject) {
                return (PObject)gObject;
            }
            return null;
        }
        if (n == this.list.size()) {
            if (this.list.isEmpty()) {
                return null;
            }
            GObject gObject = this.list.remove(n - 1);
            if (gObject instanceof PObject) {
                return (PObject)gObject;
            }
            return null;
        }
        if (n == 0) {
            return null;
        }
        throw new RuntimeException("Parser.del(): index out of range");
    }

    private Vector<String> getStringVector(int n) {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        for (GObject gObject : this.list) {
            if (gObject instanceof PObject) {
                PObject pObject = (PObject)gObject;
                for (String string : pObject.name_array()) {
                    vector.add(string);
                }
            }
            if (++n2 < Math.min(n, this.list.size())) continue;
            break;
        }
        return vector;
    }

    private Vector<String> getListAsStringVector() {
        Vector<String> vector = new Vector<String>();
        for (GObject gObject : this.list) {
            Object object;
            if (gObject instanceof PObject) {
                object = (PObject)gObject;
                for (String string : ((PObject)object).name_array()) {
                    vector.add(string);
                }
                continue;
            }
            if (gObject instanceof Complex) {
                object = (Complex)gObject;
                String string = Double.toString(((Complex)object).real()) + "+i" + Double.toString(((Complex)object).imaginary());
                vector.add(string);
                continue;
            }
            if (!(gObject instanceof Double)) continue;
            object = (Double)((Object)gObject);
            vector.add(((Double)object).toString());
        }
        return vector;
    }

    public String getExpression() {
        Vector<String> vector = this.getStringVector(this.list.size());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuilder.append(vector.elementAt(i));
        }
        return stringBuilder.toString();
    }

    public String getExpression(int n) {
        int n2;
        Vector<String> vector = this.getStringVector(this.list.size());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2 = Math.max(vector.size() - n, 0); i < n2 + Math.min(vector.size(), n); ++i) {
            stringBuilder.append(vector.elementAt(i));
        }
        return stringBuilder.toString();
    }

    public void clearExpression() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final PObject getLast() {
        if (this.list.isEmpty()) {
            return null;
        }
        GObject gObject = this.list.getLast();
        if (gObject instanceof PObject) {
            return (PObject)gObject;
        }
        return null;
    }

    public boolean del() {
        if (this.list.isEmpty()) {
            return false;
        }
        ListIterator<GObject> listIterator = this.list.listIterator(this.list.size());
        listIterator.previous();
        listIterator.remove();
        return true;
    }

    public LinkedList<PObject> getList() {
        LinkedList<PObject> linkedList = new LinkedList<PObject>();
        for (GObject gObject : this.list) {
            if (!(gObject instanceof PObject)) continue;
            linkedList.add((PObject)gObject);
        }
        return linkedList;
    }

    public void setList(LinkedList<PObject> linkedList) {
        this.list.clear();
        for (PObject pObject : linkedList) {
            this.list.add(pObject);
        }
    }

    public final Base base() {
        return this.base;
    }

    public void base(Base base) {
        this.base = base;
    }

    public static String font_size(float f) {
        String string = "style=\"font-size: " + Float.toString(f) + "\"";
        return string;
    }

    public static void main(String[] stringArray) {
        Parser parser = new Parser();
        parser.add(new Numeral('3'));
        parser.add(new Numeral('.'));
        parser.add(new Numeral('1'));
        parser.add(new Numeral('4'));
        parser.add(new Multiply());
        parser.add(new LParen());
        parser.add(new Numeral('4'));
        parser.add(new Add());
        parser.add(new Numeral('5'));
        parser.add(new Cube());
        parser.add(new Subtract());
        parser.add(new Numeral('5'));
        parser.add(new Combination());
        parser.add(new Numeral('2'));
        parser.add(new RParen());
        JOptionPane.showMessageDialog(null, parser.getExpression());
        System.out.println(parser.evaluate(AngleType.DEGREES));
    }
}

