/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.ListIterator;
import jscicalc.graph.Axis;
import jscicalc.graph.Element;
import jscicalc.graph.HAxis;
import jscicalc.graph.Locus;
import jscicalc.graph.VAxis;
import jscicalc.graph.View;

public class Model {
    private HAxis xAxis = new HAxis();
    private VAxis yAxis = new VAxis();
    protected LinkedList<Element> elements = new LinkedList();

    public Model() {
        this.elements.add(this.xAxis);
        this.elements.add(this.yAxis);
    }

    public void add(Element element) {
        this.elements.add(element);
    }

    public void reset(Locus locus) {
        this.elements.clear();
        this.elements.add(this.xAxis);
        this.elements.add(this.yAxis);
        this.elements.add(locus);
    }

    public void draw(View view, Graphics2D graphics2D) {
        ListIterator listIterator = this.elements.listIterator();
        while (listIterator.hasNext()) {
            ((Element)listIterator.next()).draw(this, view, graphics2D);
        }
    }

    public void updatePaths() {
        ListIterator listIterator = this.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            if (!(element instanceof Locus)) continue;
            Locus locus = (Locus)element;
            locus.updatePath();
        }
    }

    Axis getXAxis() {
        return this.xAxis;
    }

    Axis getYAxis() {
        return this.yAxis;
    }
}

