/*
 * Decompiled with CFR 0.152.
 */
package com.skatecity.gui;

import com.skatecity.gui.FGConstraint;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class FlexingGridLayout
implements LayoutManager2 {
    private Dimension gridsize;
    private int hGap;
    private int vGap;
    private boolean hRigid = false;
    private boolean vRigid = false;
    private Hashtable compTable;
    private float[] colWeight;
    private float[] rowWeight;
    private int[] prefWidths;
    private int[] prefHeights;

    public FlexingGridLayout() {
        this(new Dimension(1, 1));
    }

    public FlexingGridLayout(Dimension size) {
        this(size, 0, 0);
    }

    public FlexingGridLayout(Dimension size, int hGap, int vGap) {
        this.setGridsize(size);
        this.hGap = hGap;
        this.vGap = vGap;
        this.compTable = new Hashtable();
    }

    public Dimension getGridsize() {
        return new Dimension(this.gridsize);
    }

    public void setGridsize(Dimension size) {
        this.setGridsize(size.width, size.height);
    }

    public void setGridsize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Dimensions must be greater than zero");
        }
        this.gridsize = new Dimension(width, height);
        this.colWeight = new float[width];
        this.rowWeight = new float[height];
        int i = 0;
        while (i < width) {
            this.colWeight[i] = 1.0f;
            ++i;
        }
        int i2 = 0;
        while (i2 < height) {
            this.rowWeight[i2] = 1.0f;
            ++i2;
        }
        this.prefWidths = new int[width];
        this.prefHeights = new int[height];
    }

    public void setRigidWidth(boolean choice) {
        this.hRigid = choice;
    }

    public void setRigidHeight(boolean choice) {
        this.vRigid = choice;
    }

    public void setRowWeight(int row, float weight) {
        if (row < 0 || row >= this.gridsize.height) {
            throw new IllegalArgumentException("Invalid row index.");
        }
        if (weight < 0.0f) {
            weight = 0.0f;
        }
        this.rowWeight[row] = weight;
    }

    public void setColumnWeight(int col, float weight) {
        if (col < 0 || col >= this.gridsize.width) {
            throw new IllegalArgumentException("Invalid column index.");
        }
        if (weight < 0.0f) {
            weight = 0.0f;
        }
        this.colWeight[col] = weight;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        Rectangle r;
        if (constraints instanceof FGConstraint) {
            r = ((FGConstraint)constraints).getLocation();
        } else if (constraints instanceof Rectangle) {
            r = (Rectangle)constraints;
        } else {
            throw new IllegalArgumentException("Cannot add to layout: Constraint of wrong class");
        }
        if (r.x < 0 || r.y < 0) {
            throw new IllegalArgumentException("Cannot add to layout: Rect x and y must be >= 0");
        }
        if (r.width < 1 || r.height < 1) {
            throw new IllegalArgumentException("Cannot add to layout: Rect width and height must be > 0");
        }
        this.setConstraints(comp, constraints);
    }

    public void setConstraints(Component comp, Object constraints) {
        if (!(constraints instanceof FGConstraint) && !(constraints instanceof Rectangle)) {
            throw new IllegalArgumentException("Invalid constraints for FG");
        }
        this.compTable.put(comp, constraints);
    }

    public void removeLayoutComponent(Component comp) {
        this.compTable.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateCellSizes(parent, true);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateCellSizes(parent, false);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private Dimension calculateCellSizes(Container parent, boolean isPreferred) {
        Dimension size = new Dimension(0, 0);
        int ccount = parent.getComponentCount();
        if (ccount == 0) {
            return size;
        }
        int i = 0;
        while (i < this.gridsize.width) {
            this.prefWidths[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.gridsize.height) {
            this.prefHeights[i2] = 0;
            ++i2;
        }
        int i3 = 0;
        while (i3 < ccount) {
            block39: {
                Rectangle r;
                Component c;
                block41: {
                    Object o;
                    block40: {
                        c = parent.getComponent(i3);
                        if (c == null) break block39;
                        o = this.compTable.get(c);
                        if (!(o instanceof FGConstraint)) break block40;
                        r = ((FGConstraint)o).getLocation();
                        break block41;
                    }
                    if (!(o instanceof Rectangle)) break block39;
                    r = (Rectangle)o;
                }
                if (r != null) {
                    Dimension csize = c.getPreferredSize();
                    if (r.width == 1) {
                        this.prefWidths[r.x] = Math.max(this.prefWidths[r.x], csize.width);
                    }
                    if (r.height == 1) {
                        this.prefHeights[r.y] = Math.max(this.prefHeights[r.y], csize.height);
                    }
                }
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < ccount) {
            block42: {
                Rectangle r;
                Component c;
                block44: {
                    Object o;
                    block43: {
                        c = parent.getComponent(i4);
                        if (c == null) break block42;
                        o = this.compTable.get(c);
                        if (!(o instanceof FGConstraint)) break block43;
                        r = ((FGConstraint)o).getLocation();
                        break block44;
                    }
                    if (!(o instanceof Rectangle)) break block42;
                    r = (Rectangle)o;
                }
                if (r != null) {
                    int allocated;
                    Dimension csize = c.getPreferredSize();
                    if (r.width > 1) {
                        allocated = (r.width - 1) * this.hGap;
                        float weight = 0.0f;
                        int j = 0;
                        while (j < r.width) {
                            int x = r.x + j;
                            weight += this.colWeight[x];
                            if (x < this.gridsize.width) {
                                allocated += this.prefWidths[x];
                            } else {
                                allocated = Short.MAX_VALUE;
                                break;
                            }
                            ++j;
                        }
                        int excess = csize.width - allocated;
                        if (excess > 0) {
                            int j2;
                            if ((double)weight > 0.0) {
                                float distribute = (float)excess / weight;
                                j2 = 0;
                                while (j2 < r.width) {
                                    int n = r.x + j2;
                                    this.prefWidths[n] = this.prefWidths[n] + (int)(this.colWeight[r.x + j2] * distribute);
                                    ++j2;
                                }
                            } else {
                                int distribute = excess / r.width;
                                j2 = 0;
                                while (j2 < r.width) {
                                    int n = r.x + j2;
                                    this.prefWidths[n] = this.prefWidths[n] + distribute;
                                    ++j2;
                                }
                            }
                        }
                    }
                    if (r.height > 1) {
                        allocated = (r.height - 1) * this.vGap;
                        int j = 0;
                        while (j < r.height) {
                            int y = r.y + j;
                            if (y < this.gridsize.height) {
                                allocated += this.prefHeights[y];
                            } else {
                                allocated = Short.MAX_VALUE;
                                break;
                            }
                            ++j;
                        }
                        if (allocated < csize.height) {
                            int distribute = (csize.height - allocated) / r.height;
                            int j3 = 0;
                            while (j3 < r.height) {
                                int n = r.y + j3;
                                this.prefHeights[n] = this.prefHeights[n] + distribute;
                                ++j3;
                            }
                        }
                    }
                }
            }
            ++i4;
        }
        if (this.hRigid) {
            int maxwidth = 0;
            int i5 = 0;
            while (i5 < this.gridsize.width) {
                maxwidth = Math.max(maxwidth, this.prefWidths[i5]);
                ++i5;
            }
            int i6 = 0;
            while (i6 < this.gridsize.width) {
                this.prefWidths[i6] = maxwidth;
                ++i6;
            }
        }
        if (this.vRigid) {
            int maxheight = 0;
            int i7 = 0;
            while (i7 < this.gridsize.height) {
                maxheight = Math.max(maxheight, this.prefHeights[i7]);
                ++i7;
            }
            int i8 = 0;
            while (i8 < this.gridsize.height) {
                this.prefHeights[i8] = maxheight;
                ++i8;
            }
        }
        Insets ins = parent.getInsets();
        int i9 = 0;
        while (i9 < this.gridsize.width) {
            size.width += this.prefWidths[i9];
            ++i9;
        }
        int i10 = 0;
        while (i10 < this.gridsize.height) {
            size.height += this.prefHeights[i10];
            ++i10;
        }
        size.width += this.hGap * (this.gridsize.width - 1) + ins.left + ins.right;
        size.height += this.vGap * (this.gridsize.height - 1) + ins.top + ins.bottom;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int addHere;
            int i;
            int prevAdded;
            int i2;
            float weight;
            int ccount = parent.getComponentCount();
            if (ccount == 0) {
                return;
            }
            Dimension psize = parent.getSize();
            Insets insets = parent.getInsets();
            Dimension minsize = this.calculateCellSizes(parent, false);
            int[] leftEdge = new int[this.gridsize.width + 1];
            int[] topEdge = new int[this.gridsize.height + 1];
            int[] rightEdge = new int[this.gridsize.width + 1];
            int[] bottomEdge = new int[this.gridsize.height + 1];
            leftEdge[0] = insets.left;
            topEdge[0] = insets.top;
            int i3 = 0;
            while (i3 < this.gridsize.width) {
                rightEdge[i3] = leftEdge[i3] + this.prefWidths[i3];
                leftEdge[i3 + 1] = rightEdge[i3] + this.hGap;
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.gridsize.height) {
                bottomEdge[i4] = topEdge[i4] + this.prefHeights[i4];
                topEdge[i4 + 1] = bottomEdge[i4] + this.vGap;
                ++i4;
            }
            int xExcess = psize.width - minsize.width;
            int yExcess = psize.height - minsize.height;
            if (xExcess != 0) {
                weight = 0.0f;
                i2 = 0;
                while (i2 < this.gridsize.width) {
                    weight += this.colWeight[i2];
                    ++i2;
                }
                if ((double)weight > 0.0) {
                    prevAdded = 0;
                    i = 0;
                    while (i < this.gridsize.width) {
                        addHere = (int)(this.colWeight[i] / weight * (float)xExcess);
                        int n = i;
                        rightEdge[n] = rightEdge[n] + (addHere + prevAdded);
                        int n2 = i + 1;
                        leftEdge[n2] = leftEdge[n2] + (addHere + prevAdded);
                        prevAdded += addHere;
                        ++i;
                    }
                }
            }
            if (yExcess != 0) {
                weight = 0.0f;
                i2 = 0;
                while (i2 < this.gridsize.height) {
                    weight += this.rowWeight[i2];
                    ++i2;
                }
                if ((double)weight > 0.0) {
                    prevAdded = 0;
                    i = 0;
                    while (i < this.gridsize.height) {
                        addHere = (int)(this.rowWeight[i] / weight * (float)yExcess);
                        int n = i;
                        bottomEdge[n] = bottomEdge[n] + (addHere + prevAdded);
                        int n3 = i + 1;
                        topEdge[n3] = topEdge[n3] + (addHere + prevAdded);
                        prevAdded += addHere;
                        ++i;
                    }
                }
            }
            int i5 = 0;
            while (i5 < ccount) {
                block31: {
                    double vAlignment;
                    double hAlignment;
                    Rectangle r;
                    Component c;
                    block33: {
                        Object o;
                        block32: {
                            c = parent.getComponent(i5);
                            if (c == null) break block31;
                            o = this.compTable.get(c);
                            if (!(o instanceof FGConstraint)) break block32;
                            r = ((FGConstraint)o).getLocation();
                            hAlignment = ((FGConstraint)o).getHAlignment();
                            vAlignment = ((FGConstraint)o).getVAlignment();
                            break block33;
                        }
                        if (o instanceof Rectangle) {
                            r = (Rectangle)o;
                            try {
                                hAlignment = c.getAlignmentX();
                                vAlignment = c.getAlignmentY();
                            }
                            catch (Exception ignore) {
                                break block31;
                            }
                        }
                        break block31;
                    }
                    if (r != null && r.x < this.gridsize.width && r.y < this.gridsize.height) {
                        int dy;
                        int dx;
                        int left = leftEdge[r.x];
                        int top = topEdge[r.y];
                        int right = r.x + r.width <= this.gridsize.width ? rightEdge[r.x + r.width - 1] : rightEdge[this.gridsize.width - 1];
                        int bottom = r.y + r.height <= this.gridsize.height ? bottomEdge[r.y + r.height - 1] : bottomEdge[this.gridsize.height - 1];
                        int w = right - left;
                        int h = bottom - top;
                        Dimension prefSize = c.getPreferredSize();
                        Dimension maxSize = c.getMaximumSize();
                        if (w > prefSize.width && prefSize.width > 0) {
                            w = prefSize.width;
                        }
                        if (w > maxSize.width && maxSize.width > 0) {
                            w = maxSize.width;
                        }
                        if (h > prefSize.height && prefSize.height > 0) {
                            h = prefSize.height;
                        }
                        if (h > maxSize.height && maxSize.height > 0) {
                            h = maxSize.height;
                        }
                        if ((dx = right - left - w) > 0) {
                            int shift;
                            if (hAlignment != -1.0) {
                                shift = (int)(hAlignment * (double)dx);
                                left += shift;
                            } else if (!((double)c.getAlignmentX() < 0.0) && !((double)c.getAlignmentX() > 1.0)) {
                                shift = (int)(c.getAlignmentX() * (float)dx);
                                left += shift;
                            }
                        }
                        if ((dy = bottom - top - h) > 0) {
                            int shift;
                            if (vAlignment != -1.0) {
                                shift = (int)(vAlignment * (double)dy);
                                top += shift;
                            } else if (!((double)c.getAlignmentY() < 0.0) && !((double)c.getAlignmentY() > 1.0)) {
                                shift = (int)(c.getAlignmentY() * (float)dy);
                                top += shift;
                            }
                        }
                        c.setBounds(left, top, w, h);
                    }
                }
                ++i5;
            }
        }
    }

    public void invalidateLayout(Container target) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }
}

