/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.KeyStroke;

public class CommonShortcuts {
    private static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final String QUIT_NAME = "Quit";
    public static final String NEW_NAME = "New";
    public static final String OPEN_NAME = "Open";
    public static final String CLOSE_NAME = "Close";
    public static final String SAVE_NAME = "Save";
    public static final String SAVEAS_NAME = "Save As\u2026";
    public static final String PAGESETUP_NAME = "Page Setup\u2026";
    public static final String PRINT_NAME = "Print\u2026";
    public static final String UNDO_NAME = "Undo";
    public static final String REDO_NAME = "Redo";
    public static final String EDIT_NAME = "Edit";
    public static final String CUT_NAME = "Cut";
    public static final String COPY_NAME = "Copy";
    public static final String PASTE_NAME = "Paste";
    public static final String SELECTALL_NAME = "Select All";
    public static final String CLEAR_NAME = "Paste";
    public static final String MINIMIZE_NAME = "Minimize";
    public static final String PREFERENCES_NAME = "Preferences\u2026";
    private static Hashtable keystrokesHash = new Hashtable();

    public static KeyStroke get(String name) {
        try {
            return (KeyStroke)keystrokesHash.get(name.toLowerCase());
        }
        catch (Exception exc) {
            return null;
        }
    }

    static {
        keystrokesHash.put(QUIT_NAME.toLowerCase(), KeyStroke.getKeyStroke(81, SHORTCUT_MASK));
        keystrokesHash.put(NEW_NAME.toLowerCase(), KeyStroke.getKeyStroke(78, SHORTCUT_MASK));
        keystrokesHash.put(OPEN_NAME.toLowerCase(), KeyStroke.getKeyStroke(79, SHORTCUT_MASK));
        keystrokesHash.put(CLOSE_NAME.toLowerCase(), KeyStroke.getKeyStroke(87, SHORTCUT_MASK));
        keystrokesHash.put(SAVE_NAME.toLowerCase(), KeyStroke.getKeyStroke(83, SHORTCUT_MASK));
        keystrokesHash.put(PAGESETUP_NAME.toLowerCase(), KeyStroke.getKeyStroke(80, SHORTCUT_MASK | 1));
        keystrokesHash.put(SAVEAS_NAME.toLowerCase(), KeyStroke.getKeyStroke(83, SHORTCUT_MASK | 1));
        keystrokesHash.put(PRINT_NAME.toLowerCase(), KeyStroke.getKeyStroke(80, SHORTCUT_MASK));
        keystrokesHash.put(UNDO_NAME.toLowerCase(), KeyStroke.getKeyStroke(90, SHORTCUT_MASK));
        keystrokesHash.put(REDO_NAME.toLowerCase(), KeyStroke.getKeyStroke(90, SHORTCUT_MASK | 1));
        keystrokesHash.put(COPY_NAME.toLowerCase(), KeyStroke.getKeyStroke(67, SHORTCUT_MASK));
        keystrokesHash.put(CUT_NAME.toLowerCase(), KeyStroke.getKeyStroke(88, SHORTCUT_MASK));
        keystrokesHash.put("Paste".toLowerCase(), KeyStroke.getKeyStroke(86, SHORTCUT_MASK));
        keystrokesHash.put(SELECTALL_NAME.toLowerCase(), KeyStroke.getKeyStroke(65, SHORTCUT_MASK));
        if (System.getProperty("mrj.version") != null) {
            keystrokesHash.put(MINIMIZE_NAME.toLowerCase(), KeyStroke.getKeyStroke(77, SHORTCUT_MASK));
        } else {
            keystrokesHash.put(PREFERENCES_NAME.toLowerCase(), KeyStroke.getKeyStroke(75, SHORTCUT_MASK));
        }
    }
}

