/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping;

import gov.nasa.giss.mapping.Landmark;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class LandmarkList {
    private Vector data = new Vector(0, 10);

    public LandmarkList() {
    }

    public LandmarkList(File f) throws MalformedURLException {
        this(new URL("file://" + f.getAbsolutePath()));
    }

    public LandmarkList(URL urlBase, String fname) throws MalformedURLException {
        this(new URL(urlBase, fname));
    }

    public LandmarkList(URL url) {
        try {
            this.loadData(url);
        }
        catch (Exception exc) {
            System.out.println("LandmarkList init, bad URL -- " + url);
            System.out.println(exc.toString());
        }
    }

    public int count() {
        return this.data.size();
    }

    public Landmark getElement(int element) {
        return (Landmark)this.data.elementAt(element);
    }

    public int getElementType(int element) {
        return ((Landmark)this.data.elementAt(element)).getType();
    }

    public String getElementName(int element) {
        return ((Landmark)this.data.elementAt(element)).getName();
    }

    public double getElementLongitude(int element) {
        return ((Landmark)this.data.elementAt(element)).getLongitude();
    }

    public double getElementLatitude(int element) {
        return ((Landmark)this.data.elementAt(element)).getLatitude();
    }

    private void loadData(URL dataURL) {
        String aLine = "";
        try {
            BufferedReader inputStream = new BufferedReader(new InputStreamReader(dataURL.openStream()));
            while ((aLine = inputStream.readLine()) != null) {
                int lType = 99;
                double lLon = 0.0;
                double lLat = 0.0;
                String lName = "";
                String lCode = "";
                boolean lDefault = false;
                Color lColor = Color.green;
                boolean enough = false;
                while ((aLine = inputStream.readLine()) != null) {
                    int bgnIdx = 0;
                    int endIdx = 0;
                    if (aLine.indexOf("<type") > -1) {
                        if (aLine.indexOf("planned lander") > 0) {
                            lType = 2;
                            lDefault = true;
                            lColor = Color.cyan;
                            continue;
                        }
                        if (aLine.indexOf("lander site") > 0) {
                            lType = 1;
                            lDefault = true;
                            lColor = Color.green;
                            continue;
                        }
                        if (aLine.indexOf("surface feature") > 0) {
                            lType = 4;
                            lDefault = false;
                            lColor = Color.yellow;
                            continue;
                        }
                        if (aLine.indexOf("crash site") <= 0) continue;
                        lType = 3;
                        lDefault = false;
                        lColor = Color.red;
                        continue;
                    }
                    if (aLine.indexOf("<code") > -1) {
                        bgnIdx = aLine.indexOf("value=") + 7;
                        endIdx = aLine.indexOf(" />") - 1;
                        lCode = aLine.substring(bgnIdx, endIdx);
                        continue;
                    }
                    if (aLine.indexOf("<name") > -1) {
                        bgnIdx = aLine.indexOf("value=") + 7;
                        endIdx = aLine.indexOf(" />") - 1;
                        lName = aLine.substring(bgnIdx, endIdx);
                        enough = true;
                        continue;
                    }
                    if (aLine.indexOf("<longitude") > -1) {
                        bgnIdx = aLine.indexOf("value=") + 7;
                        endIdx = aLine.indexOf(" />") - 1;
                        lLon = Double.valueOf(aLine.substring(bgnIdx, endIdx));
                        continue;
                    }
                    if (aLine.indexOf("<latitude") > -1) {
                        bgnIdx = aLine.indexOf("value=") + 7;
                        endIdx = aLine.indexOf(" />") - 1;
                        lLat = Double.valueOf(aLine.substring(bgnIdx, endIdx));
                        continue;
                    }
                    if (aLine.indexOf("</landmark>") > -1) break;
                }
                if (!enough) continue;
                this.data.addElement(new Landmark(lType, lLon, lLat, lDefault, lCode, lName, lColor));
            }
            inputStream.close();
        }
        catch (Exception exc) {
            System.out.println(exc.toString());
        }
        this.sort();
    }

    public void sort() {
        if (this.count() < 2) {
            return;
        }
        this.sort(0, this.count() - 1);
    }

    public void sort(int from, int to) {
        if (from == to) {
            return;
        }
        Landmark center = (Landmark)this.data.elementAt((from + to) / 2);
        int i = from;
        int j = to;
        while (true) {
            if (i < to && center.compareTo((Landmark)this.data.elementAt(i)) > 0) {
                ++i;
                continue;
            }
            while (j > from && center.compareTo((Landmark)this.data.elementAt(j)) < 0) {
                --j;
            }
            if (i < j) {
                Landmark tmp = (Landmark)this.data.elementAt(i);
                this.data.setElementAt(this.data.elementAt(j), i);
                this.data.setElementAt(tmp, j);
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            this.sort(from, j);
        }
        if (i < to) {
            this.sort(i, to);
        }
    }
}

