/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Mollweide
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Mollweide";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final double FIT_WIDTH = 2.0 * SQRT2;
    private static final double FIT_HEIGHT = SQRT2;
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Mollweide(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Mollweide(Integer dw, Integer dh, Integer xm, Integer ym, Double lon) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)lon);
    }

    public Mollweide(int dw, int dh, int xm, int ym, double lon) {
        this.init(dw, dh, xm, ym, lon, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double oneOverSqrt2RS = this.oneOverRS / SQRT2;
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            double thetaRad = Math.asin((double)y * oneOverSqrt2RS);
            double phi = AbstractProjection.toDegrees(Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907));
            if (phi > 90.0 || phi < -90.0) break;
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            int ySrc = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int ySrcF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = 90.0 * this.oneOverRS / (SQRT2 * Math.cos(thetaRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = (double)(-x) * xFactor;
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xSrc = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xSrcF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xSrc >= this.srcWidth) {
                    xSrc -= this.srcWidth;
                }
                while (xSrcF >= this.srcWidth) {
                    xSrcF -= this.srcWidth;
                }
                while (xSrc < 0) {
                    xSrc += this.srcWidth;
                }
                while (xSrcF < 0) {
                    xSrcF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = ySrc * this.srcWidth + xSrc;
                this.invArray[row * this.dstWidth + colF] = ySrc * this.srcWidth + xSrcF;
                this.invArray[rowF * this.dstWidth + col] = ySrcF * this.srcWidth + xSrc;
                this.invArray[rowF * this.dstWidth + colF] = ySrcF * this.srcWidth + xSrcF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double piSinPhi = Math.PI * Math.sin(AbstractProjection.toRadians(lat));
        double thetaRad = AbstractProjection.toRadians(lat);
        int i = 0;
        while (i < 25) {
            double twoThetaRad = 2.0 * thetaRad;
            double dthetaRad = 0.5 * (piSinPhi - twoThetaRad - Math.sin(twoThetaRad)) / (1.0 + Math.cos(twoThetaRad));
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
            ++i;
        }
        double dlambda = lon - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -SQRT2 * this.rS * dlambda * Math.cos(thetaRad) / 90.0;
        double y = SQRT2 * this.rS * Math.sin(thetaRad);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

