/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Parabolic
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Parabolic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double SQRT3PI;
    private static final double FIT_WIDTH;
    private static final double FIT_HEIGHT;
    public static final double ASPECT_RATIO;
    private double scaleFactor = 1.0;
    private double radius;
    private double rSSqrt3Pi;
    private double oneOverRSSqrt3Pi;
    private double rSSqrt3OverPi;

    public Parabolic(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Parabolic(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Parabolic(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        double rS = this.radius * this.scaleFactor;
        this.rSSqrt3Pi = rS * SQRT3PI;
        this.rSSqrt3OverPi = rS * Math.sqrt(0.954929658551372);
        this.oneOverRSSqrt3Pi = 1.0 / this.rSSqrt3Pi;
        this.needsUpdate = true;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int row = this.yMargin;
        while (row < this.dstHeight - this.yMargin) {
            double y = this.yCenter - row;
            if (!(y > this.rSSqrt3Pi) && !(y < -this.rSSqrt3Pi)) {
                double phiRad = 3.0 * Math.asin(y * this.oneOverRSSqrt3Pi);
                int yMap = (int)(this.srcYPixPerDeg * (90.0 - AbstractProjection.toDegrees(phiRad)));
                double xFactor = this.rSSqrt3OverPi * 0.5 * 2.0 * (2.0 * Math.cos(2.0 * phiRad / 3.0) - 1.0);
                int col = 0;
                while (col < this.dstWidth) {
                    double dlambdaRad = (double)(col - this.xCenter) / xFactor;
                    if (!(dlambdaRad > Math.PI) && !(dlambdaRad <= -Math.PI)) {
                        int xMap = (int)(this.srcXPixPerDeg * (180.0 + AbstractProjection.toDegrees(dlambdaRad) - this.copLon));
                        while (xMap >= this.srcWidth) {
                            xMap -= this.srcWidth;
                        }
                        while (xMap < 0) {
                            xMap += this.srcWidth;
                        }
                        this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                    }
                    ++col;
                }
            }
            ++row;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double dlambda = lon - this.copLon;
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        double phiRadOver3 = AbstractProjection.toRadians(lat) / 3.0;
        double x = -this.rSSqrt3OverPi * AbstractProjection.toRadians(dlambda) * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
        double y = this.rSSqrt3Pi * Math.sin(phiRadOver3);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }

    static {
        FIT_WIDTH = SQRT3PI = Math.sqrt(Math.PI * 3);
        FIT_HEIGHT = 0.5 * SQRT3PI;
        ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    }
}

