/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.graphics.NatCubic;
import gov.nasa.giss.time.MarsTime;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;

public class M24HorizonPlotter {
    private static final long HALFDAY = 43200000L;
    private static final long MAJOR_INTERVAL = 3600000L;
    private static final long MINOR_INTERVAL = 1200000L;
    private static final long TINY_INTERVAL = 240000L;
    private static final Font LABEL_FONT = new Font("Courier", 0, 18);
    private static final Font NOTES_FONT = new Font("Courier", 0, 12);
    private static final DecimalFormat FORMAT_X1 = new DecimalFormat("0.0");
    private int width;
    private int height;
    private double pixPerDeg;
    private int pix45;
    private int pix90;
    private int pix135;
    private int pix180;
    private int pix270;
    private int pix360;

    public M24HorizonPlotter(int w, int h) {
        this.width = w;
        this.height = h;
        this.pixPerDeg = (double)this.width / 360.0;
        this.pix45 = (int)(this.pixPerDeg * 45.0);
        this.pix90 = (int)(this.pixPerDeg * 90.0);
        this.pix135 = (int)(this.pixPerDeg * 135.0);
        this.pix180 = (int)(this.pixPerDeg * 180.0);
        this.pix270 = (int)(this.pixPerDeg * 270.0);
        this.pix360 = this.width;
    }

    public void draw(Graphics g, MarsTime mTime, double lon, double lat, boolean lookNorth) {
        int aziPixel;
        int zenPixel;
        double azimuthAngle;
        double zenithAngle;
        double xzenithAngle = mTime.getZenithAngle(lon, lat);
        g.setColor(new Color(153, 51, 0));
        g.fillRect(0, 0, this.width, this.pix180);
        if (xzenithAngle > 91.0) {
            g.setColor(new Color(0, 0, 0));
        } else if (xzenithAngle > 90.0) {
            double howdark = 91.0 - xzenithAngle;
            int dr = 0xFF0000 & (int)(1.4483456E7 * howdark);
            int dg = 0xFF00 & (int)(39168.0 * howdark);
            int db = 0xFF & (int)(153.0 * howdark);
            g.setColor(new Color(dr | dg | db));
        } else {
            g.setColor(new Color(221, 153, 153));
        }
        g.fillRect(0, 0, this.width, this.pix90);
        g.setColor(Color.white);
        int j = 0;
        while (j < 181) {
            int y = (int)((double)j * this.pixPerDeg);
            if (j / 90 * 90 == j) {
                g.drawLine(0, y, this.width, y);
            } else {
                int i = 5;
                while (i < this.width) {
                    g.drawLine(i, y, i + 10, y);
                    i += 20;
                }
            }
            j += 45;
        }
        int i = 0;
        while (i < 360) {
            int x = (int)((double)i * this.pixPerDeg);
            if (i / 90 * 90 == i) {
                g.drawLine(x, 0, x, this.height);
            } else {
                int j2 = 5;
                while (j2 < this.height) {
                    g.drawLine(x, j2, x, j2 + 10);
                    j2 += 20;
                }
            }
            i += 45;
        }
        g.setColor(Color.blue);
        g.setFont(NOTES_FONT);
        if (lookNorth) {
            g.drawString("S", 2, this.pix45 - 2);
            g.drawString("W", this.pix90 + 2, this.pix45 - 2);
            g.drawString("N", this.pix180 + 2, this.pix45 - 2);
            g.drawString("E", this.pix270 + 2, this.pix45 - 2);
        } else {
            g.drawString("N", 2, this.pix45 - 2);
            g.drawString("E", this.pix90 + 2, this.pix45 - 2);
            g.drawString("S", this.pix180 + 2, this.pix45 - 2);
            g.drawString("W", this.pix270 + 2, this.pix45 - 2);
        }
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
        NatCubic solarPath = new NatCubic();
        int lastAziPixel = this.pix180;
        long millis = mTime.getMillis();
        double tsLon = lon;
        double tsLat = lat;
        g.setColor(Color.white);
        long interval = 1200000L;
        int pixels = 0;
        long k = -43200000L;
        while (k < 44400000L) {
            MarsTime xTime = new MarsTime(millis + (long)(1.027491252 * (double)k));
            zenithAngle = xTime.getZenithAngle(tsLon, tsLat);
            azimuthAngle = xTime.getAzimuthAngle(tsLon, tsLat);
            zenPixel = (int)(zenithAngle * this.pixPerDeg);
            aziPixel = (int)(azimuthAngle * this.pixPerDeg);
            if (!lookNorth && (aziPixel -= this.pix180) < -this.pix180) {
                aziPixel += this.width;
            }
            if (Math.abs((aziPixel += this.pix180) - lastAziPixel) > this.pix180) {
                solarPath.paint(g);
                solarPath = new NatCubic();
                solarPath.addPoint(aziPixel, zenPixel);
            } else if (zenPixel < 4 || zenPixel > this.height - 4) {
                solarPath.paint(g);
                solarPath = new NatCubic();
            } else {
                solarPath.addPoint(aziPixel, zenPixel);
            }
            lastAziPixel = aziPixel;
            interval = aziPixel < 40 || aziPixel > this.width - 40 || zenPixel < 20 || zenPixel > this.height - 20 ? 240000L : 1200000L;
            ++pixels;
            k += interval;
        }
        g.setColor(Color.white);
        solarPath.paint(g);
        long k2 = -43200000L;
        while (k2 < 43200000L) {
            MarsTime xTime = new MarsTime(millis + (long)(1.027491252 * (double)k2));
            zenithAngle = xTime.getZenithAngle(tsLon, tsLat);
            azimuthAngle = xTime.getAzimuthAngle(tsLon, tsLat);
            zenPixel = (int)(zenithAngle * this.pixPerDeg);
            aziPixel = (int)(azimuthAngle * this.pixPerDeg);
            if (!lookNorth && (aziPixel -= this.pix180) < -this.pix180) {
                aziPixel += this.width;
            }
            aziPixel += this.pix180;
            if (k2 == 0L) {
                g.setColor(Color.yellow);
                g.fillOval(aziPixel - 4, zenPixel - 4, 8, 8);
                g.setColor(Color.white);
            } else {
                g.setColor(Color.white);
                g.drawOval(aziPixel - 2, zenPixel - 2, 4, 4);
            }
            k2 += 3600000L;
        }
    }
}

