/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class M24DayNightMap
extends Component {
    private static final double UNKNOWN = 9999.0;
    private static final double DEFAULT_SUBSOLAR_LON = 0.0;
    private static final double DEFAULT_SUBSOLAR_LAT = 0.0;
    private static final int transparentRGB = new Color(0, 0, 0, 0).getRGB();
    private Image src;
    private BufferedImage dst;
    private Graphics2D dstGfx;
    private BufferedImage shadow;
    private Graphics2D shadowGfx;
    private int imgWidth;
    private int imgHeight;
    private int imgWidthP1;
    private int imgHeightP1;
    private int srcWidth;
    private int srcHeight;
    private boolean needsRedraw = true;
    private int maxOpaque = 153;
    private double maxOpaqueF = this.maxOpaque;
    private double brightCos = 0.2;
    private double pixPerDeg;
    private double degPerPix;
    private int darkSkip;
    private double[] mapLon;
    private double[] mapLat;
    private double[] cosMapColat;
    private double[] sinMapColat;
    private double[][] cosZ;
    private double[] cosDTheta;
    private double subsolarLon;
    private double subsolarLat;
    private double cosSubsolarColat;
    private double sinSubsolarColat;

    public M24DayNightMap(Image img) {
        this(img, 0.0, 0.0);
    }

    public M24DayNightMap(Image img, double lon, double lat) {
        this.src = img;
        this.srcWidth = this.src.getWidth(this);
        this.srcHeight = this.src.getHeight(this);
        this.imgWidth = 200;
        this.imgHeight = this.imgWidth / 2;
        this.imgWidthP1 = this.imgWidth + 1;
        this.imgHeightP1 = this.imgHeight + 1;
        this.shadow = new BufferedImage(this.imgWidth, this.imgHeight, 2);
        this.shadowGfx = (Graphics2D)this.shadow.getGraphics();
        this.dst = new BufferedImage(this.srcWidth, this.srcHeight, 2);
        this.dstGfx = (Graphics2D)this.dst.getGraphics();
        this.pixPerDeg = (double)this.imgWidth / 360.0;
        this.degPerPix = 1.0 / this.pixPerDeg;
        this.darkSkip = this.imgWidth / 6;
        this.cosDTheta = new double[this.imgWidthP1];
        this.cosZ = new double[this.imgHeightP1][this.imgWidthP1];
        this.mapLon = new double[this.imgWidthP1];
        this.mapLat = new double[this.imgHeightP1];
        this.cosMapColat = new double[this.imgHeightP1];
        this.sinMapColat = new double[this.imgHeightP1];
        int i = 0;
        while (i < this.imgWidthP1) {
            this.mapLon[i] = 180.0 - this.degPerPix * (double)i;
            ++i;
        }
        int j = 0;
        while (j < this.imgHeightP1) {
            double mapColat = this.degPerPix * (double)j;
            this.mapLat[j] = 90.0 - mapColat;
            this.cosMapColat[j] = Math.cos(Math.toRadians(mapColat));
            this.sinMapColat[j] = Math.sin(Math.toRadians(mapColat));
            ++j;
        }
        this.setSubsolarPoint(lon, lat);
    }

    public void setSubsolarPoint(double lon, double lat) {
        this.subsolarLon = lon;
        this.subsolarLat = lat;
        this.cosSubsolarColat = Math.cos(Math.toRadians(90.0 - this.subsolarLat));
        this.sinSubsolarColat = Math.sin(Math.toRadians(90.0 - this.subsolarLat));
        this.needsRedraw = true;
    }

    public Image getMap() {
        if (this.needsRedraw) {
            this.drawTerminator();
            this.needsRedraw = false;
        }
        return this.dst;
    }

    private void drawTerminator() {
        int j;
        int i = 0;
        while (i < this.imgWidth) {
            int j2 = 0;
            while (j2 < this.imgHeight) {
                this.shadow.setRGB(i, j2, transparentRGB);
                ++j2;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.imgWidthP1) {
            this.cosDTheta[i2] = 9999.0;
            j = 0;
            while (j < this.imgHeightP1) {
                this.cosZ[j][i2] = 9999.0;
                ++j;
            }
            ++i2;
        }
        j = 0;
        while (j < this.imgHeight) {
            int jx = j + this.darkSkip;
            if (jx > this.imgHeight) {
                jx = this.imgHeight;
            }
            int i3 = 0;
            while (i3 < this.imgWidth) {
                int ix = i3 + this.darkSkip;
                if (ix > this.imgWidth) {
                    ix = this.imgWidth;
                }
                this.drawDarkness(this.shadowGfx, i3, ix, j, jx);
                i3 += this.darkSkip;
            }
            j += this.darkSkip;
        }
        this.dstGfx.drawImage(this.src, 0, 0, this);
        this.dstGfx.drawImage(this.shadow, 0, 0, this.srcWidth, this.srcHeight, 0, 0, this.imgWidth, this.imgHeight, this);
        this.needsRedraw = false;
    }

    private void drawDarkness(Graphics2D g, int left, int right, int top, int bottom) {
        if (left < 0 || bottom < 0) {
            return;
        }
        if (right > this.imgWidth || bottom > this.imgHeight) {
            return;
        }
        int width = right - left;
        int height = bottom - top;
        if (width < 1 || height < 1) {
            return;
        }
        boolean isDark = true;
        double minCos = 1.0;
        int k = 0;
        while (k < 4) {
            int jx;
            int ix;
            if (k == 0) {
                ix = left;
                jx = top;
            } else if (k == 1) {
                ix = right;
                jx = top;
            } else if (k == 2) {
                ix = left;
                jx = bottom;
            } else {
                ix = right;
                jx = bottom;
            }
            if (this.cosZ[jx][ix] == 9999.0) {
                if (this.cosDTheta[ix] == 9999.0) {
                    this.cosDTheta[ix] = Math.cos(Math.toRadians(this.subsolarLon - this.mapLon[ix]));
                }
                this.cosZ[jx][ix] = this.cosSubsolarColat * this.cosMapColat[jx] + this.sinSubsolarColat * this.sinMapColat[jx] * this.cosDTheta[ix];
            }
            if (this.cosZ[jx][ix] > 0.0) {
                isDark = false;
            }
            minCos = Math.min(minCos, this.cosZ[jx][ix]);
            ++k;
        }
        if (isDark) {
            g.setColor(new Color(0, 0, 0, this.maxOpaque));
            g.fillRect(left, top, width, height);
        } else if (!(minCos > this.brightCos)) {
            int opacity;
            if (minCos > 0.0 && width < 2 && height < 2) {
                opacity = (int)(this.maxOpaqueF * (1.0 - minCos / this.brightCos));
                if (opacity < 0) {
                    opacity = 0;
                } else if (opacity > this.maxOpaque) {
                    opacity = this.maxOpaque;
                }
                g.setColor(new Color(0, 0, 0, opacity));
                g.fillRect(left, top, width, height);
            } else if (width < 2 && height < 2) {
                opacity = (int)(this.maxOpaqueF * (1.0 - minCos / this.brightCos));
                if (opacity < 0) {
                    opacity = 0;
                } else if (opacity > this.maxOpaque) {
                    opacity = this.maxOpaque;
                }
                g.setColor(new Color(0, 0, 0, opacity));
                g.fillRect(left, top, width, height);
            } else if (width < height) {
                int yAve = (top + bottom) / 2;
                this.drawDarkness(g, left, right, top, yAve);
                this.drawDarkness(g, left, right, yAve, bottom);
            } else {
                int xAve = (left + right) / 2;
                this.drawDarkness(g, left, xAve, top, bottom);
                this.drawDarkness(g, xAve, right, top, bottom);
            }
        }
    }
}

