/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import com.jhlabs.image.QuantizeFilter;
import com.keypoint.PngEncoderB;
import gov.nasa.giss.img.GIF87aEncoder;
import gov.nasa.giss.mars24.application.M24DisplayPanel;
import gov.nasa.giss.mars24.application.M24Globals;
import gov.nasa.giss.mars24.application.M24Menubar;
import gov.nasa.giss.mars24.application.M24WindowMenu;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;

public class M24DisplayFrame
extends JFrame
implements Printable,
SwingConstants {
    private static final boolean RESIZABLE = false;
    private JPanel content;
    private JScrollPane scrollPane;
    private static boolean canPaint = true;
    private File dstFile;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private PrintAction printAction;

    public M24DisplayFrame(String title, JPanel panel, int hAlign, int vAlign) {
        this.content = panel;
        this.setTitle(title);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                ((M24WindowMenu)((M24Menubar)M24DisplayFrame.this.getJMenuBar()).getMenu("Window")).update();
            }
        });
        this.getContentPane().add(this.content);
        this.pack();
        this.setJMenuBar(new M24Menubar(this));
        this.saveAction = new SaveAction();
        this.saveAsAction = new SaveAsAction();
        this.printAction = new PrintAction();
        this.saveAction.setEnabled(true);
        this.saveAsAction.setEnabled(true);
        this.printAction.setEnabled(true);
        M24Menubar mbar = (M24Menubar)this.getJMenuBar();
        mbar.getMenu("File").setItemAction("Save", this.saveAction);
        mbar.getMenu("File").setItemAction("Save As\u2026", this.saveAsAction);
        mbar.getMenu("File").setItemAction("Print\u2026", this.printAction);
        Rectangle rr = M24Globals.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            int x = 25;
            int y = 25;
            Dimension psize = panel.getPreferredSize();
            if (hAlign == 0) {
                x = (rr.width - psize.width) / 2;
            } else if (hAlign == 4) {
                x = rr.width - psize.width - 25;
            }
            if (vAlign == 0) {
                y = (rr.height - psize.height) / 2;
            } else if (vAlign == 3) {
                y = rr.height - psize.height - 25;
            }
            this.setLocation(rr.x + x, rr.y + y);
        }
        this.setVisible(true);
        Runnable clockRunner = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException exc) {
                        exc.printStackTrace();
                    }
                    if (!canPaint) continue;
                    M24DisplayFrame.this.repaint();
                }
            }
        };
        Thread clockThread = new Thread(clockRunner, title + "ticker");
        clockThread.start();
    }

    public void print() {
        canPaint = false;
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
        canPaint = true;
    }

    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        BufferedImage src = (BufferedImage)((M24DisplayPanel)((Object)this.content)).getImage();
        double srcWidth = ((Image)src).getWidth(this);
        double srcHeight = ((Image)src).getHeight(this);
        double paddingX = 0.5 * (pf.getImageableWidth() - srcHeight);
        double paddingY = 0.5 * (pf.getImageableHeight() - srcWidth);
        double scale = 1.0;
        if (paddingX < 0.0) {
            srcWidth *= (scale *= pf.getImageableWidth() / srcHeight);
            srcHeight *= scale;
            paddingX = 0.0;
            paddingY = 0.5 * (pf.getImageableHeight() - scale * srcWidth);
        }
        if (paddingY < 0.0) {
            scale *= pf.getImageableHeight() / (scale * srcWidth);
            paddingY = 0.0;
            paddingX = 0.5 * (pf.getImageableWidth() - scale * srcHeight);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX() + pf.getImageableWidth() - paddingX, pf.getImageableY() + paddingY);
        g2.rotate(1.5707963267948966);
        g2.scale(scale, scale);
        g2.drawImage((Image)src, 0, 0, this);
        return 0;
    }

    public void saveAsGIF(Image img, File f) {
        try {
            FileOutputStream oStream = new FileOutputStream(f);
            boolean success = false;
            try {
                GIF87aEncoder ge = new GIF87aEncoder(img);
                ge.write(oStream);
                success = true;
            }
            catch (Exception exc) {
                success = false;
            }
            if (!success) {
                try {
                    int width = img.getWidth(this);
                    int height = img.getHeight(this);
                    int[] srcPixels = new int[width * height];
                    int[] dstPixels = new int[width * height];
                    PixelGrabber grabber = new PixelGrabber(img, 0, 0, width, height, srcPixels, 0, width);
                    try {
                        grabber.grabPixels();
                    }
                    catch (Exception exc) {
                        return;
                    }
                    QuantizeFilter qf = new QuantizeFilter();
                    qf.quantize(srcPixels, dstPixels, width, height, 256, false, true);
                    GIF87aEncoder ge = new GIF87aEncoder(dstPixels, width, height);
                    ge.write(oStream);
                }
                catch (Exception exc) {
                    System.out.println("Unable to save image as a GIF.");
                    exc.printStackTrace();
                }
            }
            oStream.close();
        }
        catch (Exception exc) {
            System.out.println("Unable to save image as a GIF.");
            exc.printStackTrace();
        }
    }

    public void saveAsPNG(Image img, File f) {
        block3: {
            PngEncoderB pe = new PngEncoderB((BufferedImage)img, false, 0, 5);
            try {
                byte[] pngbytes = pe.pngEncode();
                if (pngbytes == null) {
                    System.out.println("Null image");
                    break block3;
                }
                FileOutputStream oStream = new FileOutputStream(f);
                oStream.write(pngbytes);
                oStream.flush();
                oStream.close();
            }
            catch (Exception exc) {
                System.out.println("Unable to save image as a PNG.");
                exc.printStackTrace();
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super("Save as\u2026");
        }

        public void actionPerformed(ActionEvent e) {
            canPaint = false;
            FileDialog fd = new FileDialog((Frame)M24DisplayFrame.this, "Save plot PNG or GIF as\u2026", 1);
            String frameTitle = M24DisplayFrame.this.getTitle();
            if (frameTitle.toLowerCase().endsWith(".png") || frameTitle.toLowerCase().endsWith(".gif")) {
                fd.setFile(frameTitle);
            } else {
                fd.setFile(frameTitle + ".png");
            }
            fd.setVisible(true);
            if (fd.getFile() == null) {
                canPaint = true;
                return;
            }
            String fname = fd.getFile().toLowerCase().endsWith(".png") || fd.getFile().toLowerCase().endsWith(".gif") ? fd.getFile() : fd.getFile() + ".png";
            try {
                M24DisplayFrame.this.dstFile = new File(fd.getDirectory(), fname);
                if (M24DisplayFrame.this.dstFile.getName().toLowerCase().endsWith(".gif")) {
                    M24DisplayFrame.this.saveAsGIF(((M24DisplayPanel)((Object)M24DisplayFrame.this.content)).getImage(), M24DisplayFrame.this.dstFile);
                } else {
                    M24DisplayFrame.this.saveAsPNG(((M24DisplayPanel)((Object)M24DisplayFrame.this.content)).getImage(), M24DisplayFrame.this.dstFile);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            canPaint = true;
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("Save");
        }

        public void actionPerformed(ActionEvent e) {
            canPaint = false;
            if (M24DisplayFrame.this.dstFile == null) {
                M24DisplayFrame.this.saveAsAction.actionPerformed(null);
            } else if (M24DisplayFrame.this.dstFile.getName().toLowerCase().endsWith(".gif")) {
                M24DisplayFrame.this.saveAsGIF(((M24DisplayPanel)((Object)M24DisplayFrame.this.content)).getImage(), M24DisplayFrame.this.dstFile);
            } else {
                M24DisplayFrame.this.saveAsPNG(((M24DisplayPanel)((Object)M24DisplayFrame.this.content)).getImage(), M24DisplayFrame.this.dstFile);
            }
            canPaint = true;
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super("Print\u2026");
        }

        public void actionPerformed(ActionEvent e) {
            block2: {
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setPrintable(M24DisplayFrame.this);
                if (!pj.printDialog()) break block2;
                try {
                    pj.print();
                }
                catch (Exception PrintException) {
                    PrintException.printStackTrace();
                }
            }
        }
    }
}

