/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import gov.nasa.giss.mapping.PointDouble;
import gov.nasa.giss.mapping.proj.Aitoff;
import gov.nasa.giss.mapping.proj.Eckert6;
import gov.nasa.giss.mapping.proj.Equirectangular;
import gov.nasa.giss.mapping.proj.Hammer;
import gov.nasa.giss.mapping.proj.Mollweide;
import gov.nasa.giss.mapping.proj.Orthographic;
import gov.nasa.giss.mapping.proj.Parabolic;
import gov.nasa.giss.mapping.proj.Projection;
import gov.nasa.giss.mapping.proj.Wagner4;
import gov.nasa.giss.mapping.proj.Wagner5;
import gov.nasa.giss.mapping.proj.WinkelTripel;
import gov.nasa.giss.mars24.Landmark;
import gov.nasa.giss.mars24.LandmarkEvent;
import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.LandmarkListener;
import gov.nasa.giss.mars24.M24HorizonPlotter;
import gov.nasa.giss.mars24.M24OrbitPlotter;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.mars24.application.M24DayNightMap;
import gov.nasa.giss.mars24.application.M24DisplayPanel;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.MarsTime;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class M24PlotPanel
extends JPanel
implements LandmarkListener,
M24DisplayPanel,
M24TimekeeperListener {
    private static final int DEFAULT_PLOT_WIDTH = 720;
    private static final int DEFAULT_DARKNESS = 55;
    public static final int LOOK_NORTH = 1;
    public static final int LOOK_SOUTH = 2;
    private static final int CROSS = 0;
    private static final int CIRCLE = 1;
    public static final String MAP_DISPLAY = "Sunclock Map";
    public static final String ORBIT_DISPLAY = "Orbital Position";
    public static final String HORIZON_DISPLAY = "Local Horizon";
    public static final String[] DISPLAY_CHOICES = new String[]{"Sunclock Map", "Orbital Position", "Local Horizon"};
    private static final double DEFAULT_COP_LONGITUDE = 0.0;
    private static final double DEFAULT_COP_LATITUDE = 35.0;
    private static final int DEFAULT_DISPLAY = 0;
    private static final String DEFAULT_MAP_NAME = Orthographic.getProjectionName();
    private static final DecimalFormat FORMAT_X2 = new DecimalFormat("0.00");
    private int displayID = 0;
    private M24Timekeeper timekeeper;
    private int panelWidth;
    private int panelHeight;
    private int useWidth;
    private int useHeight;
    private int orbitSize;
    private int xMargin;
    private int yMargin;
    private boolean gfxInitialized;
    private boolean projectionChanged = true;
    private boolean pmapNeedsUpdate = true;
    private boolean omapNeedsUpdate = true;
    private boolean shadowNeedsUpdate = true;
    private boolean horizonNeedsUpdate = true;
    private boolean orbitNeedsUpdate = true;
    private long lastShadowUpdate;
    private long lastHorizonUpdate;
    private long lastOrbitUpdate;
    private int fHeightError;
    private int fheightNotes1;
    private int fheightNotes2;
    private int fHeightTiny;
    private Font fontError;
    private Font fontNotes1;
    private Font fontNotes2;
    private Font fontTiny;
    private FontMetrics fm;
    private boolean showLanders = false;
    private boolean markSubsolar = false;
    private boolean markLLGrid = false;
    private int horizonDirect = 2;
    private double copLon = 0.0;
    private double copLat = 35.0;
    private Image offscreenMain;
    private Graphics ogfx;
    private Image sourceMap;
    private M24DayNightMap shadowMap;
    private Image projectedMap;
    private Image offscreenMap;
    private Projection projection;
    private Image offscreenHorizon;
    private Image offscreenOrbit;
    private M24HorizonPlotter horizonPlotter;
    private M24OrbitPlotter orbitPlotter;
    private LandmarkList landmarks;
    private static String version = "Mars24 5.1";
    private static Object[] mapChoices = new String[]{Aitoff.getProjectionName(), Eckert6.getProjectionName(), Equirectangular.getProjectionName(), Hammer.getProjectionName(), Mollweide.getProjectionName(), Orthographic.getProjectionName(), Parabolic.getProjectionName(), Wagner4.getProjectionName(), Wagner5.getProjectionName(), WinkelTripel.getProjectionName()};
    private int mapID;

    public M24PlotPanel() {
        throw new IllegalArgumentException("Use another constructor");
    }

    public M24PlotPanel(M24Timekeeper tk, LandmarkList ll, Image src) {
        this(tk, 720, 360, ll, src);
    }

    public M24PlotPanel(M24Timekeeper tk, int w, int h, LandmarkList ll, Image src) {
        if (tk == null) {
            throw new IllegalArgumentException("Timekeeper cannot be null");
        }
        if (w < 0) {
            throw new IllegalArgumentException("Width must be positive");
        }
        if (src == null) {
            throw new IllegalArgumentException("Source image cannot be null");
        }
        this.timekeeper = tk;
        this.timekeeper.addTimekeeperListener(this);
        this.landmarks = ll;
        this.sourceMap = src;
        this.init(w, h);
        this.setBackground(Color.black);
        this.setOpaque(true);
        this.mapID = 0;
        int i = 0;
        while (i < mapChoices.length) {
            if (((String)mapChoices[i]).equals(DEFAULT_MAP_NAME)) {
                this.mapID = i;
                break;
            }
            ++i;
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.init(w, h);
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.init(d.width, d.height);
    }

    private void init(int w, int h) {
        if (w != this.panelWidth || h != this.panelHeight) {
            this.panelWidth = w;
            this.panelHeight = h;
            if (this.panelWidth > 1000) {
                this.fHeightError = 24;
                this.fheightNotes1 = 16;
                this.fheightNotes2 = 14;
                this.fHeightTiny = 9;
            } else {
                this.fHeightError = 20;
                this.fheightNotes1 = 13;
                this.fheightNotes2 = 11;
                this.fHeightTiny = 9;
            }
            this.fontError = new Font("Courier", 1, this.fHeightError);
            this.fontNotes1 = new Font("Courier", 1, this.fheightNotes1);
            this.fontNotes2 = new Font("Courier", 1, this.fheightNotes2);
            this.fontTiny = new Font("Courier", 0, this.fHeightTiny);
            this.xMargin = 2;
            this.yMargin = this.fheightNotes1 + 4;
            this.useWidth = this.panelWidth - 2 * this.xMargin;
            this.useHeight = this.panelHeight - 2 * this.yMargin;
            if (this.useWidth / 2 > this.useHeight) {
                this.useWidth = this.useHeight * 2;
                this.panelWidth = this.useWidth + 2 * this.xMargin;
            } else if (this.useWidth / 2 < this.useHeight) {
                this.useHeight = this.useWidth / 2;
                this.panelHeight = this.useHeight + 2 * this.yMargin;
            }
            this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
            this.setMinimumSize(new Dimension(360 + 2 * this.xMargin, 180 + 2 * this.yMargin));
            this.setMaximumSize(this.getPreferredSize());
            this.gfxInitialized = false;
        }
    }

    public void paintComponent(Graphics g) {
        String description;
        long startTime = System.currentTimeMillis();
        if (!this.gfxInitialized) {
            this.offscreenMain = this.createImage(this.panelWidth, this.panelHeight);
            this.projection = null;
            this.projectionChanged = true;
            this.shadowNeedsUpdate = true;
            this.pmapNeedsUpdate = true;
            this.omapNeedsUpdate = true;
            this.horizonPlotter = null;
            this.orbitPlotter = null;
            this.ogfx = this.offscreenMain.getGraphics();
            this.gfxInitialized = true;
        }
        MarsTime mTime = this.timekeeper.getMarsTime();
        EarthTime eTime = this.timekeeper.getEarthTime();
        if (mTime == null) {
            g.setColor(Color.red);
            g.setFont(this.fontError);
            FontMetrics fm = g.getFontMetrics();
            String message1 = "Time/date out of valid range or not";
            String message2 = "well-formatted. Please re-enter.";
            g.drawString(message1, (this.panelWidth - fm.stringWidth(message1)) / 2, (this.panelHeight - this.fHeightError) / 2 - 2);
            g.drawString(message2, (this.panelWidth - fm.stringWidth(message2)) / 2, (this.panelHeight + this.fHeightError) / 2 + 2);
            return;
        }
        this.ogfx.setColor(Color.black);
        this.ogfx.fillRect(0, 0, this.panelWidth, this.panelHeight);
        if (DISPLAY_CHOICES[this.displayID] == ORBIT_DISPLAY) {
            this.drawOrbit(this.ogfx, mTime, eTime);
        } else if (DISPLAY_CHOICES[this.displayID] == HORIZON_DISPLAY) {
            this.drawHorizon(this.ogfx, mTime);
        } else {
            this.drawMap(this.ogfx, mTime);
        }
        this.ogfx.setColor(Color.green);
        this.ogfx.setFont(this.fontNotes1);
        this.fm = this.ogfx.getFontMetrics();
        this.ogfx.drawString("NASA GISS", this.xMargin + 2, this.fheightNotes1);
        this.ogfx.drawString(version, this.panelWidth - this.xMargin - 2 - this.fm.stringWidth(version), this.fheightNotes1);
        this.ogfx.setFont(this.fontNotes2);
        this.fm = this.ogfx.getFontMetrics();
        if (DISPLAY_CHOICES[this.displayID] == ORBIT_DISPLAY) {
            description = "Relative Orbital Positions";
        } else if (DISPLAY_CHOICES[this.displayID] == HORIZON_DISPLAY) {
            description = "Apparent Horizon at " + FORMAT_X2.format(this.timekeeper.getSiteLongitude()) + "\u00b0W " + FORMAT_X2.format(this.timekeeper.getSiteLatitude()) + "\u00b0N";
        } else {
            StringBuffer sb = new StringBuffer("Sunclock");
            sb.append(" (").append(this.projection.getName()).append(")");
            sb.append(" Centered on ");
            sb.append(FORMAT_X2.format(this.copLon) + "\u00b0W");
            if (this.projection.isAzimuthal()) {
                sb.append(" " + FORMAT_X2.format(this.copLat) + "\u00b0N");
            }
            description = sb.toString();
        }
        this.ogfx.drawString(description, this.xMargin + 2, this.panelHeight - 4);
        String tString = eTime.getDate(false, this.timekeeper.getShowDateAsDOY()) + " " + eTime.getTime() + " / " + mTime.getTimestr(0.0, 1, false) + " MTC";
        this.ogfx.drawString(tString, this.panelWidth - this.xMargin - 2 - this.fm.stringWidth(tString), this.panelHeight - 4);
        g.drawImage(this.offscreenMain, 0, 0, this);
    }

    public PointDouble transformXY2LL(int x, int y) {
        if (DISPLAY_CHOICES[this.displayID] == MAP_DISPLAY) {
            if (this.projection == null) {
                return null;
            }
            if ((x -= this.xMargin) < 0 || (y -= this.yMargin) < 0) {
                return null;
            }
            return this.projection.transformXY2LL(x, y);
        }
        return null;
    }

    public static Object[] getMapChoices() {
        return mapChoices;
    }

    public int getMapID() {
        return this.mapID;
    }

    public void setMapID(int choice) {
        if (choice == this.mapID) {
            return;
        }
        this.mapID = choice;
        this.projectionChanged = true;
        this.pmapNeedsUpdate = true;
        this.repaint();
    }

    public int getDisplayID() {
        return this.displayID;
    }

    public void setDisplayID(int choice) {
        if (choice == this.displayID) {
            return;
        }
        if (choice < 0 || choice > DISPLAY_CHOICES.length - 1) {
            throw new IllegalArgumentException("Unknown display choice '" + choice + "'");
        }
        this.displayID = choice;
        this.horizonNeedsUpdate = true;
        this.orbitNeedsUpdate = true;
        this.pmapNeedsUpdate = true;
        this.repaint();
        JFrame f = (JFrame)this.getTopLevelAncestor();
        if (f != null) {
            if (DISPLAY_CHOICES[this.displayID] == ORBIT_DISPLAY) {
                f.setTitle("Mars24 - Orbits");
            } else if (DISPLAY_CHOICES[this.displayID] == HORIZON_DISPLAY) {
                f.setTitle("Mars24 - Horizon");
            } else {
                f.setTitle("Mars24 - Sunclock");
            }
        }
    }

    public double getCOPLongitude() {
        return this.copLon;
    }

    public double getCOPLatitude() {
        return this.copLat;
    }

    public void setCOP(double lon, double lat) {
        if (lon == this.copLon && lat == this.copLat) {
            return;
        }
        this.copLon = lon;
        this.copLat = lat;
        if (this.projection != null) {
            this.projection.setCenter(this.copLon, this.copLat);
        }
        this.pmapNeedsUpdate = true;
        this.repaint();
    }

    public void setCOP(String xString, String yString) {
        try {
            double lon = Double.valueOf(xString);
            double lat = Double.valueOf(yString);
            while (lat > 90.0) {
                lat -= 180.0;
            }
            while (lat < -90.0) {
                lat += 180.0;
            }
            while (lon > 360.0) {
                lon -= 360.0;
            }
            while (lon < 0.0) {
                lon += 360.0;
            }
            this.setCOP(lon, lat);
        }
        catch (Exception exc) {
            System.out.println("setCOP error -- " + exc.toString());
            return;
        }
    }

    public boolean getMarkLLGrid() {
        return this.markLLGrid;
    }

    public void setMarkLLGrid(boolean value) {
        if (this.markLLGrid == value) {
            return;
        }
        this.markLLGrid = value;
        this.pmapNeedsUpdate = true;
        this.repaint();
    }

    public boolean getMarkSubsolar() {
        return this.markSubsolar;
    }

    public void setMarkSubsolar(boolean value) {
        if (this.markSubsolar == value) {
            return;
        }
        this.markSubsolar = value;
        this.omapNeedsUpdate = true;
        this.repaint();
    }

    public int getHorizonCenter() {
        return this.horizonDirect;
    }

    public void setHorizonCenter(int value) {
        if (this.horizonDirect == value) {
            return;
        }
        this.horizonDirect = value;
        this.horizonNeedsUpdate = true;
        this.repaint();
    }

    private void drawMap(Graphics g, MarsTime mTime) {
        long now = System.currentTimeMillis();
        if (this.shadowMap == null) {
            this.shadowMap = new M24DayNightMap(this.sourceMap, mTime.getSubsolarLongitude(), mTime.getSolarDeclination());
            this.shadowNeedsUpdate = false;
            this.lastShadowUpdate = now;
            this.pmapNeedsUpdate = true;
        } else if (this.shadowNeedsUpdate || now - this.lastShadowUpdate > 90000L) {
            this.shadowMap.setSubsolarPoint(mTime.getSubsolarLongitude(), mTime.getSolarDeclination());
            this.shadowNeedsUpdate = false;
            this.lastShadowUpdate = now;
            this.pmapNeedsUpdate = true;
        }
        if (this.projectedMap == (Image)null || this.offscreenMap == (Image)null) {
            this.projectedMap = this.createImage(this.useWidth, this.useHeight);
            this.offscreenMap = this.createImage(this.useWidth, this.useHeight);
            this.projectionChanged = true;
            this.pmapNeedsUpdate = true;
        }
        if (this.projectionChanged) {
            this.projection = new Projection(Projection.getProjectionID((String)mapChoices[this.mapID]), this.useWidth, this.useHeight, this.copLon, this.copLat);
            this.projection.setBackgroundColor(Color.black);
            this.projection.setGridColor(new Color(204, 255, 204));
            this.projection.setGridLabeled(true);
            this.projectionChanged = false;
            this.pmapNeedsUpdate = true;
        }
        if (this.pmapNeedsUpdate) {
            if (this.markLLGrid) {
                this.projection.drawMap(this.shadowMap.getMap(), this.projectedMap.getGraphics(), 30);
            } else {
                this.projection.drawMap(this.shadowMap.getMap(), this.projectedMap.getGraphics());
            }
            this.pmapNeedsUpdate = false;
            this.omapNeedsUpdate = true;
        }
        if (this.omapNeedsUpdate) {
            Graphics omapgfx = this.offscreenMap.getGraphics();
            omapgfx.drawImage(this.projectedMap, 0, 0, this);
            if (this.markSubsolar) {
                this.markSpot(omapgfx, mTime.getSubsolarLongitude(), mTime.getSolarDeclination(), 1, Color.red, Color.yellow);
                this.markSpot(omapgfx, this.timekeeper.getSiteLongitude(), this.timekeeper.getSiteLatitude(), 0, Color.white);
            }
            int i = 0;
            while (i < this.landmarks.count()) {
                Landmark l = this.landmarks.getElement(i);
                if (l.isMarked()) {
                    this.markSpot(omapgfx, l.getLongitude(), l.getLatitude(), 0, l.getColor(), l.getCode());
                }
                ++i;
            }
        }
        g.drawImage(this.offscreenMap, this.xMargin, this.yMargin, this);
        this.omapNeedsUpdate = false;
    }

    private void markSpot(Graphics g, double lon, double latitude) {
        this.markSpot(g, lon, latitude, 0, Color.white, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, Color lineColor) {
        this.markSpot(g, lon, lat, 0, lineColor, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor) {
        this.markSpot(g, lon, lat, shape, lineColor, null, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, Color fillColor) {
        this.markSpot(g, lon, lat, shape, lineColor, fillColor, "");
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, String label) {
        this.markSpot(g, lon, lat, shape, lineColor, null, label);
    }

    private void markSpot(Graphics g, double lon, double lat, int shape, Color lineColor, Color fillColor, String label) {
        if (this.projection == null) {
            return;
        }
        Point xy = this.projection.transformLL2XY(lon, lat);
        if (xy == null) {
            return;
        }
        int x = xy.x;
        int y = xy.y;
        if (shape == 0) {
            g.setColor(lineColor);
            g.drawLine(x - 2, y, x + 2, y);
            g.drawLine(x, y - 2, x, y + 2);
        } else if (shape == 1) {
            if (fillColor != null) {
                g.setColor(fillColor);
                g.fillOval(x - 3, y - 3, 6, 6);
            }
            g.setColor(lineColor);
            g.drawOval(x - 3, y - 3, 6, 6);
        }
        if (label.length() < 1) {
            return;
        }
        g.setColor(lineColor);
        g.setFont(this.fontNotes1);
        this.fm = g.getFontMetrics();
        x = x + 2 + this.fm.stringWidth(label) > this.useWidth ? (x -= 2 + this.fm.stringWidth(label)) : (x += 2);
        y = y - 2 - this.fheightNotes1 < 0 ? (y += this.fheightNotes1) : (y -= 2);
        g.drawString(label, x, y);
    }

    private void drawHorizon(Graphics g, MarsTime mTime) {
        long now = System.currentTimeMillis();
        if (this.offscreenHorizon == (Image)null) {
            this.offscreenHorizon = this.createImage(this.useWidth, this.useHeight);
            this.horizonNeedsUpdate = true;
        }
        if (this.horizonPlotter == null) {
            this.horizonPlotter = new M24HorizonPlotter(this.useWidth, this.useHeight);
            this.horizonNeedsUpdate = true;
        }
        if (this.horizonNeedsUpdate || now - this.lastHorizonUpdate > 15000L) {
            this.horizonPlotter.draw(this.offscreenHorizon.getGraphics(), mTime, this.timekeeper.getSiteLongitude(), this.timekeeper.getSiteLatitude(), this.horizonDirect == 1);
            this.lastHorizonUpdate = now;
            this.horizonNeedsUpdate = false;
        }
        g.drawImage(this.offscreenHorizon, this.xMargin, this.yMargin, this);
    }

    private void drawOrbit(Graphics g, MarsTime mTime0, EarthTime eTime0) {
        long now = System.currentTimeMillis();
        if (this.offscreenOrbit == (Image)null) {
            this.orbitSize = Math.min(this.useWidth, this.useHeight);
            this.offscreenOrbit = this.createImage(this.orbitSize, this.orbitSize);
            this.orbitNeedsUpdate = true;
        }
        if (this.orbitPlotter == null) {
            this.orbitPlotter = new M24OrbitPlotter(this.orbitSize, this.orbitSize);
            this.orbitNeedsUpdate = true;
        }
        if (this.orbitNeedsUpdate || now - this.lastOrbitUpdate > 120000L) {
            this.orbitPlotter.draw(this.offscreenOrbit.getGraphics(), this.timekeeper.getMillis(), mTime0, eTime0);
            this.lastOrbitUpdate = now;
        }
        g.drawImage(this.offscreenOrbit, (this.panelWidth - this.orbitSize) / 2, (this.panelHeight - this.orbitSize) / 2, this);
        this.orbitNeedsUpdate = false;
    }

    public Image getImage() {
        return this.offscreenMain;
    }

    public void timeChanged(M24TimekeeperEvent e) {
        this.pmapNeedsUpdate = true;
        this.shadowNeedsUpdate = true;
        this.horizonNeedsUpdate = true;
        this.orbitNeedsUpdate = true;
        this.repaint();
    }

    public void siteChanged(M24TimekeeperEvent e) {
        this.horizonNeedsUpdate = true;
        this.repaint();
    }

    public void formatChanged(M24TimekeeperEvent e) {
        this.repaint();
    }

    public void stateChanged(LandmarkEvent e) {
        this.omapNeedsUpdate = true;
        this.repaint();
    }
}

