/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import gov.nasa.giss.gui.CommonShortcuts;
import gov.nasa.giss.mars24.application.M24AboutFrame;
import gov.nasa.giss.mars24.application.M24AbstractMenu;
import gov.nasa.giss.mars24.application.M24ControlsFrame;
import gov.nasa.giss.mars24.application.M24DisplayFrame;
import gov.nasa.giss.mars24.application.M24HelpFrame;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class M24WindowMenu
extends M24AbstractMenu {
    protected static final String RADIO_ICON_KEY = "RadioButtonMenuItem.checkIcon";
    protected static final String CHECK_ICON_KEY = "CheckBoxMenuItem.checkIcon";
    private JRadioButtonMenuItem miShowControls;
    private JRadioButtonMenuItem miShowTime;
    private JRadioButtonMenuItem miShowPlot;
    private JRadioButtonMenuItem miShowGuide;
    private JRadioButtonMenuItem miShowNotes;
    private Frame frame;

    public M24WindowMenu(Frame f) {
        super("Window");
        this.frame = f;
        JMenuItem miMinimize = new JMenuItem("Minimize Window");
        KeyStroke shortcut = CommonShortcuts.get("minimize");
        if (shortcut != null) {
            miMinimize.setAccelerator(shortcut);
        }
        miMinimize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.frame.setState(1);
            }
        });
        this.add(miMinimize).setEnabled(true);
        this.addSeparator();
        Object radioIcon = UIManager.get(RADIO_ICON_KEY);
        UIManager.put(RADIO_ICON_KEY, UIManager.get(CHECK_ICON_KEY));
        this.miShowControls = new JRadioButtonMenuItem("Settings");
        this.miShowControls.setAccelerator(KeyStroke.getKeyStroke(49, M24AbstractMenu.SHORTCUT_MASK));
        this.miShowControls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame[] flist = Frame.getFrames();
                int i = 0;
                while (i < flist.length) {
                    if (flist[i] instanceof M24ControlsFrame) {
                        M24WindowMenu.this.selectFrame(flist[i]);
                    }
                    ++i;
                }
            }
        });
        this.add(this.miShowControls).setEnabled(true);
        this.miShowTime = new JRadioButtonMenuItem("Numeric Time");
        this.miShowTime.setAccelerator(KeyStroke.getKeyStroke(50, M24AbstractMenu.SHORTCUT_MASK));
        this.miShowTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame[] flist = Frame.getFrames();
                int i = 0;
                while (i < flist.length) {
                    if (flist[i].getTitle().indexOf("Time") > -1) {
                        M24WindowMenu.this.selectFrame(flist[i]);
                    }
                    ++i;
                }
            }
        });
        this.add(this.miShowTime).setEnabled(true);
        this.miShowPlot = new JRadioButtonMenuItem("Graphic Display");
        this.miShowPlot.setAccelerator(KeyStroke.getKeyStroke(51, M24AbstractMenu.SHORTCUT_MASK));
        this.miShowPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame[] flist = Frame.getFrames();
                int i = 0;
                while (i < flist.length) {
                    if (flist[i].getTitle().indexOf("Sunclock") > -1) {
                        M24WindowMenu.this.selectFrame(flist[i]);
                    }
                    ++i;
                }
            }
        });
        this.add(this.miShowPlot).setEnabled(true);
        this.addSeparator();
        this.miShowGuide = new JRadioButtonMenuItem("User's Guide");
        this.miShowGuide.setAccelerator(KeyStroke.getKeyStroke(52, M24AbstractMenu.SHORTCUT_MASK));
        this.miShowGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.selectFrame(M24HelpFrame.findFrame("guide"));
            }
        });
        this.add(this.miShowGuide).setEnabled(true);
        this.miShowNotes = new JRadioButtonMenuItem("Notes About Mars Time");
        this.miShowNotes.setAccelerator(KeyStroke.getKeyStroke(53, M24AbstractMenu.SHORTCUT_MASK));
        this.miShowNotes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                M24WindowMenu.this.selectFrame(M24HelpFrame.findFrame("notes"));
            }
        });
        this.add(this.miShowNotes).setEnabled(true);
        if (System.getProperty("mrj.version") == null) {
            JMenuItem miAbout = new JMenuItem("About Mars24\u2026");
            miAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    M24AboutFrame.reveal();
                }
            });
            this.add(miAbout).setEnabled(true);
        }
        UIManager.put(RADIO_ICON_KEY, radioIcon);
        this.update();
    }

    public void selectFrame(Frame f) {
        if (f != null) {
            f.setState(0);
            f.toFront();
            f.setVisible(true);
        }
    }

    public void update() {
        Object radioIcon = UIManager.get(RADIO_ICON_KEY);
        UIManager.put(RADIO_ICON_KEY, UIManager.get(CHECK_ICON_KEY));
        if (this.frame instanceof M24ControlsFrame) {
            this.miShowControls.setSelected(true);
        } else {
            this.miShowControls.setSelected(false);
        }
        if (this.frame instanceof M24DisplayFrame) {
            if (this.frame.getTitle().indexOf("Time") > -1) {
                this.miShowPlot.setSelected(false);
                this.miShowTime.setSelected(true);
            } else {
                this.miShowPlot.setSelected(true);
                this.miShowTime.setSelected(false);
            }
        } else {
            this.miShowPlot.setSelected(false);
            this.miShowTime.setSelected(false);
        }
        if (this.frame instanceof M24HelpFrame) {
            if (this.frame.getTitle().indexOf("Guide") > -1) {
                this.miShowGuide.setSelected(false);
                this.miShowNotes.setSelected(true);
            } else {
                this.miShowGuide.setSelected(true);
                this.miShowNotes.setSelected(false);
            }
        } else {
            this.miShowGuide.setSelected(false);
            this.miShowNotes.setSelected(false);
        }
        UIManager.put(RADIO_ICON_KEY, radioIcon);
    }
}

