/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.Language;
import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Configurations
implements Serializable {
    private static final long serialVersionUID = -3766560233184966131L;
    private Font font = new Font("SansSerif", 2, 30);
    private Color fontColor = new Color(0.2f, 0.2f, 0.2f);
    private Color backColor = Color.WHITE;
    private boolean useBGImage = true;
    private String BGImagePath = "images/backgrounds/jLibris.jpg";
    private String bookPath = "";
    private int pageNum = 0;
    private boolean relax = false;
    private int dummyLangVar = 0;

    public Configurations() {
    }

    public Configurations(String chosenBookPath, Font chosenFont, Color chosenFontColor, Color chosenBackColor, boolean chosenUseBGImage, String chosenBGImagePath, int chosenPageNum, int currentLanguage) {
        this.bookPath = chosenBookPath;
        this.font = chosenFont;
        this.fontColor = chosenFontColor;
        this.backColor = chosenBackColor;
        this.useBGImage = chosenUseBGImage;
        this.BGImagePath = chosenBGImagePath;
        this.pageNum = chosenPageNum;
        this.setLanguage(currentLanguage);
    }

    public int getLanguage() {
        return Language.getLanguageIndex();
    }

    public void setLanguage(int i) {
        Language.chooseLanguage(i);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color c) {
        this.fontColor = c;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color c) {
        this.backColor = c;
    }

    public boolean isUseBGImage() {
        return this.useBGImage;
    }

    public void setUseBGImage(boolean b) {
        this.useBGImage = b;
    }

    public String getBGImagePath() {
        return this.BGImagePath;
    }

    public void setBGImagePath(String p) {
        this.BGImagePath = p;
    }

    public String getBookPath() {
        return this.bookPath;
    }

    public void setBookPath(String p) {
        this.bookPath = p;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pn) {
        this.pageNum = pn;
    }

    public boolean getRelax() {
        return this.relax;
    }

    public void setRelax(boolean r) {
        this.relax = r;
    }

    public boolean saveConfigurations() {
        this.dummyLangVar = this.getLanguage();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("config.ini"));
            oos.writeObject(this);
            oos.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void loadConfigurations() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream("config.ini"));
            Configurations tempConf = (Configurations)ois.readObject();
            this.font = tempConf.getFont();
            this.fontColor = tempConf.getFontColor();
            this.backColor = tempConf.getBackColor();
            this.useBGImage = tempConf.isUseBGImage();
            this.BGImagePath = tempConf.getBGImagePath();
            this.bookPath = tempConf.getBookPath();
            this.pageNum = tempConf.getPageNum();
            this.relax = tempConf.getRelax();
            this.setLanguage(tempConf.dummyLangVar);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

