/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.AnimatedNotifier;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public abstract class Gallery
extends JFrame {
    private static final long serialVersionUID = 3871099024738801260L;
    private Insets in;
    private int imgW;
    private BufferedImage notFoundPic;
    private BufferedImage logo;
    private BufferedImage[] pic;
    private BufferedImage[] reflection;
    private float slideSpeed = 0.0f;
    private float relativeX = -10.0f;
    private int x = -1;
    private int y = -1;
    private int indx = -1;
    private Font font = new Font("Serif", 0, 36);
    private Color groundColor;
    private Thread paintLoop;
    private Thread speedLoop;

    public Gallery(String header, String galleryName, int size) {
        this(header, galleryName, size, Color.darkGray);
    }

    public Gallery(String header, String galleryName, int size, int red, int green, int blue) {
        this(header, galleryName, size, new Color(red, green, blue));
    }

    private Gallery(String header, String galleryName, int size, Color gndClr) {
        super(header);
        this.groundColor = gndClr;
        this.setSize(700, 350);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setIgnoreRepaint(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Gallery.this.indx != -1) {
                    Gallery.this.onClick(Gallery.this.indx);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Gallery.this.x = e.getX();
                Gallery.this.y = e.getY();
                Gallery.this.slideSpeed = (float)Math.pow(1.0 - (double)Gallery.this.x / 350.0, 3.0) * 300.0f;
                Gallery.this.setCursor(Gallery.this.indx == -1 ? 0 : 12);
            }
        });
        this.pic = new BufferedImage[size];
        this.reflection = new BufferedImage[size];
        try {
            this.notFoundPic = ImageIO.read(new File("images/gallery/" + galleryName + "/notFound.jpg"));
            this.logo = ImageIO.read(new File("images/gallery/logo.png"));
        }
        catch (IOException e) {
            this.dispose();
            return;
        }
        this.imgW = this.notFoundPic.getWidth();
        int length = (this.imgW + 10) * this.pic.length - 10;
        int n = 0;
        while (n < this.pic.length) {
            try {
                this.pic[n] = ImageIO.read(new File("images/gallery/" + galleryName + "/" + n + ".jpg"));
            }
            catch (IOException e) {
                this.pic[n] = this.notFoundPic;
            }
            this.reflection[n] = new BufferedImage(this.imgW, 70, 2);
            Graphics2D rg = this.reflection[n].createGraphics();
            rg.translate(0, -70);
            rg.drawRenderedImage(this.pic[n], null);
            rg.setComposite(AlphaComposite.getInstance(6));
            rg.setPaint(new GradientPaint(0.0f, 140.0f, new Color(0.0f, 0.0f, 0.0f, 0.8f), 0.0f, 70.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f)));
            rg.fillRect(0, 0, this.imgW, 140);
            rg.dispose();
            ++n;
        }
        this.setVisible(true);
        this.createBufferStrategy(2);
        this.in = this.getInsets();
        this.setSize(700 + this.in.left + this.in.right, 350 + this.in.top + this.in.bottom);
        this.setLocationRelativeTo(null);
        if (length > 700) {
            this.speedLoop = new Thread(){

                @Override
                public void run() {
                    while (Gallery.this.isVisible()) {
                        Gallery.this.relativeX = Gallery.clamp(Gallery.this.relativeX + Gallery.this.slideSpeed, -(Gallery.this.imgW + 10) * Gallery.this.pic.length + 700, 10);
                        AnimatedNotifier.wait(50);
                    }
                }
            };
            this.speedLoop.start();
        } else {
            this.relativeX = 350 - length / 2;
        }
        this.paintLoop = new Thread(){

            @Override
            public void run() {
                BufferStrategy buffy = Gallery.this.getBufferStrategy();
                while (Gallery.this.isVisible()) {
                    try {
                        Graphics2D g2d = (Graphics2D)buffy.getDrawGraphics();
                        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        Gallery.this.draw(g2d);
                        g2d.dispose();
                        buffy.show();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.paintLoop.start();
    }

    private void draw(Graphics2D g2d) {
        g2d.translate(this.in.left, this.in.top);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, 350.0f, this.groundColor));
        g2d.fillRect(0, 0, 700, 350);
        boolean selected = false;
        int n = 0;
        while (n < this.pic.length) {
            int posX = (this.imgW + 10) * n + (int)this.relativeX;
            if (posX >= -this.imgW && posX <= 700) {
                int elevation = 0;
                if (this.x > posX && this.x < this.imgW + posX) {
                    elevation = Math.round(20 * Math.max(0, this.imgW / 2 - Math.abs(posX - this.x + this.imgW / 2)) / this.imgW);
                    if (this.y > 260 - elevation + this.in.top || this.y < 120 - elevation + this.in.top) {
                        this.indx = -1;
                    } else {
                        this.indx = n;
                        selected = true;
                        this.groundColor = this.averageColor(this.pic[n], this.x - posX, this.y - 120 + elevation - this.in.top);
                    }
                }
                g2d.drawImage(this.pic[n], null, posX, 120 - elevation);
                g2d.drawImage(this.reflection[n], posX, 330 + elevation, this.reflection[n].getWidth(), -70, null);
            }
            ++n;
        }
        if (!selected) {
            this.indx = -1;
        }
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.7f), 250.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f)));
        g2d.fillRect(0, 0, 250, 350);
        g2d.setPaint(new GradientPaint(450.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 700.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.7f)));
        g2d.fillRect(450, 0, 700, 350);
        if (this.indx != -1) {
            g2d.setColor(Color.WHITE);
            g2d.setFont(this.font);
            g2d.drawString(this.onMouseOver(this.indx), 180, 80);
        }
        g2d.drawImage(this.logo, null, 80, 20);
    }

    public abstract String onMouseOver(int var1);

    public abstract void onClick(int var1);

    private static float clamp(float a, int min, int max) {
        return a > (float)max ? (float)max : (a < (float)min ? (float)min : a);
    }

    private Color averageColor(BufferedImage bi, int x, int y) {
        int a = 10;
        int r = 0;
        int g = 0;
        int b = 0;
        int biw = bi.getWidth();
        int bih = bi.getHeight();
        int xmin = x < 10 ? 0 : x - 10;
        int xmax = x > biw - 10 ? biw : x + 10;
        int ymin = y < 10 ? 0 : y - 10;
        int ymax = y > bih - 10 ? bih : y + 10;
        int xx = xmin;
        while (xx < xmax) {
            int yy = ymin;
            while (yy < ymax) {
                int pixel = bi.getRGB(xx, yy);
                r += pixel >> 16 & 0xFF;
                g += pixel >> 8 & 0xFF;
                b += pixel & 0xFF;
                ++yy;
            }
            ++xx;
        }
        int count = (xmax - xmin) * (ymax - ymin);
        return new Color((r /= count) << 16 | (g /= count) << 8 | (b /= count));
    }
}

