/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.Configurations;
import bin.Display;
import java.awt.Color;
import java.awt.Font;

public class Theme {
    private String name;
    private Font font;
    private Color fontColor;
    private Color backColor;
    private String BGImagePath;
    private boolean useBGImage = false;

    public Theme(String name, Font chosenFont, Color chosenFontColor, Color chosenBackColor) {
        this.name = name;
        this.font = chosenFont;
        this.fontColor = chosenFontColor;
        this.backColor = chosenBackColor;
    }

    public Theme(String name, Font chosenFont, Color chosenFontColor, Color chosenBackColor, String chosenBGImagePath) {
        this(name, chosenFont, chosenFontColor, chosenBackColor);
        this.useBGImage = true;
        this.BGImagePath = chosenBGImagePath;
    }

    public void applyTheme(Display d, Configurations c) {
        d.changeFont(this.font);
        c.setFontColor(this.fontColor);
        c.setBackColor(this.backColor);
        c.setUseBGImage(this.useBGImage);
        if (this.useBGImage) {
            d.setBGImage(this.BGImagePath);
        }
        d.repaint();
        d.updateConfig();
    }

    public String getName() {
        return this.name;
    }
}

