/**
 * @(#)Credits.java
 *
 * <code>Credits</code> class shows the 'crew' of the 
 * team <code>Nerd4Ever</code> and their duties 
 * in the project.<br>
 * Just for fun.
 * 
 * @author Onur Erdem
 * @version 1.00 21.12.2009
 */

package bin;
 
import java.awt.*;
import javax.swing.*;
import java.awt.image.*;
import javax.imageio.*;
import java.io.*;
import java.util.ArrayList;

public class Credits extends JFrame{
	
	/**
	 * <code>serialVersionUID</code><br>
	 * Created by Eclipse.
	 */
	private static final long serialVersionUID = 3369292988738775430L;

	/**
	 * <code>in</code><br>
     * The Insets object used for fitting the images in the window.
     */
    private Insets in;
    
	/**
	 * <code>frame</code><br>
     * The frame number.
     */
    private int frame=0;

    /**
	 * <code>index</code><br>
     * The index of the position on the list.
     */
    private int index=0;
    
	/**
	 * <code>alpha</code><br>
     * The alpha value for the font color.
     */
    private float alpha=0.0f;
    
    /**
	 * <code>bg</code><br>
     * The background image.
     */
    private BufferedImage bg;
    
	/**
	 * <code>overlay</code><br>
     * The overlay image.
     */
    private BufferedImage overlay;
     
    /**
	 * <code>bigFont</code><br>
     * The predefined font object for names.
     */
    private Font bigFont = new Font("Sans Serif",Font.PLAIN,36);
    
	/**
	 * <code>smallFont</code><br>
     * The predefined font object for titles.
     */
    private Font smallFont = new Font("Sans Serif",Font.PLAIN,24);
	
    /**
	 * <code>crew</code><br>
     * The template array storing the names and titles.
     */
    private String[][] crew = new String[][] {
		{"jLibris",Language.getText(16)}, 			// jLibris - Credits
		{"Aybar C. Acar",Language.getText(18)}, 	// Aybar C. Acar - Instructor
		{"Funda Durupnar",Language.getText(19)}, 	// Funda Durupnar - Lab Assistant
		{"Devrim ahin",Language.getText(20)}, 		// Devrim ahin - Team Leader
		{"Devrim ahin",Language.getText(22)}, 		// Devrim ahin - Art Director
		{"Mehmet M. nar",Language.getText(21)}, 	// Mehmet M. nar - Beta Tester
		{"Onur Erdem",Language.getText(21)}, 		// Onur Erdem - Beta Tester
		{"Devrim ahin",Language.getText(17)},		// Devrim ahin - Programmer
		{"Onur Erdem",Language.getText(17)}, 		// Onur Erdem - Programmer
		{"Mehmet M. nar",Language.getText(17)}, 	// Mehmet M. nar - Programmer
		{"Gkhan apar",Language.getText(17)}, 		// Gkhan apar - Programmer
		{"Gkhan Arc",Language.getText(17)}, 		// Gkhan Arc - Programmer
		{Language.getText(31),""} 					// Translators
	};

    /**
	 * <code>tempCrew</code><br>
     * The array which will also store the translator names.
     */
	private String[][] tempCrew;

	/**
	 * The default constructor. 
     */
    public Credits() {
    	// Call the super constructor by assigning the header "Credits"
    	super(Language.getText(16));
		
		// Create another String array to store both the crew and the translators
		tempCrew = new String[crew.length+Language.languageCount()+2][2];
		// For each element in the template crew
		for (int i=0;i<crew.length;i++)
			// Carry it to the current crew
			tempCrew[i] = crew[i];
		// For each translator
		for (int j=0;j<Language.languageCount();j++)
			// Add the name of the translator
			tempCrew[j+crew.length] = new String[] {Language.getTranslatorName(j),Language.getLanguageName(j)};
		// Add "THE END"
		tempCrew[tempCrew.length-2] = new String[] {Language.getText(23),""};
		// Add a blank text so that it waits for a while
		tempCrew[tempCrew.length-1] = new String[] {"",""};

    	// Try to...
    	try {
    		// ... load the background image ...
    		bg = ImageIO.read(new File("images/credits/creditsbg.jpg"));
    		// ... and the overlay image
    		overlay = ImageIO.read(new File("images/credits/creditsoverlay.jpg"));
    	// On any error
    	} catch (IOException e) {
    		// Just dispose the window
    		dispose();
    	}
    	// Set the size to 450x300 temporarily
    	setSize(450,300);
    	// Center the window
    	setLocationRelativeTo(null);
    	// Make the window unresizable
    	setResizable(false);
    	// Set it visible
    	setVisible(true);
    	// Now get the insets
    	in = getInsets();
    	// Set the size to the desired dimensions, also considering the insets
    	setSize(450+in.left+in.right,300+in.top+in.bottom);
    	// Center the window again
    	setLocationRelativeTo(null);
    	// Create a bufferStrategy
		createBufferStrategy(2);
		// Create a new thread ...
		new Thread() {
			// ... to ...
			public void run() {
				// ... continuously ...
				while (isVisible())
				// ... try to ...
				try {
					// ... get the current Graphics object ...
					Graphics g = getBufferStrategy().getDrawGraphics();
					// ... convert it to a Graphics2D object ...
					Graphics2D g2d = (Graphics2D) g;
					// ... and invoke draw function.
					draw(g2d);
					// Dispose the Graphics object
					g.dispose();
					// Show the current buffer
					getBufferStrategy().show();
				// On any exception
				} catch (Exception e) {
					// Dispose the window
					dispose();
				}
			}
		// Now start the thread
		}.start();
		
		// Now another thread.
		new Thread() {
			// This time we will ...
			public void run() {
				// ... continuously do these:
				while (isVisible()) {
					// Increase frame by 1
					frame++;
					// Find the remainder of the frame by 200
					frame%=200;
					// Calculate the alpha variable
					alpha = (frame<100)?frame*0.01f:2-frame*0.01f;
					// If the frame is the initial one
					if (frame==0) {
						// Advance to the next element of the array
						index ++;
						// To do this, increase index by 1 and find its modulo
						index %= tempCrew.length;
					}
					// Sleep, my child, for 20 milliseconds
					AnimatedNotifier.wait(20);
				}
			}
		// Start the thread
		}.start();
    }
    
    /**
	 * <code>draw</code><br>
	 * Draws the Credits on the screen.
     * @param g2d A Graphics2D object to draw on.
     */
    public void draw(Graphics2D g2d) {
    	// Make the texts antialiased
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        // Shift to the inner top-left corner
    	g2d.translate(in.left,in.top);
    	// Draw the background image
    	g2d.drawImage(bg,null,0,0);
    	// Set the color to the alpha-applied red
    	g2d.setColor(new Color(0.5f,0.0f,0.0f,alpha));
    	// Set the font to the big one
    	g2d.setFont(bigFont);
    	// Draw the name
    	g2d.drawString(tempCrew[index][0],300-frame,130);
    	// Now the small font
    	g2d.setFont(smallFont);
    	// And the title
    	g2d.drawString(tempCrew[index][1],400-2*frame,150);
    	// Draw the overlay image
    	g2d.drawImage(overlay,null,0,0);
    }
}