/**
 * @(#)Splash.java
 *
 * <code>Splash</code> class shows an image in the
 * middle of the screen for 2 seconds and creates 
 * the Display screen.<br><br>
 * Splash class has a constructor and
 * the main method. Therefore; to start
 * the application, one must type "java Splash".
 *
 * @author Gokhan Capar
 * @version 1.00 21.12.2009
 */

package bin;
 
import javax.swing.JWindow;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import java.awt.BorderLayout;

public class Splash extends JWindow {
	
	/**
	 * <code>serialVersionUID</code><br>
	 * Created by Eclipse.
	 */
	private static final long serialVersionUID = -5545874606976816359L;
	
	/**
	* <code>nowait</code>
	* This boolean is used when the user doesn't want 
	* to see long animations. Since some algorithms 
	* can run very fast, some animations like splash 
	* screen or <code>AnimatedNotifier</code>s may not 
	* be seen properly. To avoid this, A notifier screen 
	* is set to be on the screen at least for 1500 
	* milliseconds. Likewise, Splash screen stays on the 
	* screen for 2 seconds.<br>
	* This time interval can be boring. To let the user 
	* close this feature, <code>nowait</code> boolean 
	* holds whether the program will wait or not. 
	* <code>nowait</code> is false by default, but it can 
	* be changed to true by adding <code>-nowait</code> 
	* to the command line.
	*/
	private static boolean nowait = false;
	
	/**
	* Constructor of Splash screen.
	* @param filename Path of the image that will be shown.
	*/
    private Splash(String filename) {
    	// Create a JLabel to store the image.
        JLabel l = new JLabel(new ImageIcon(filename));
        // Add the JLabel to the JWindow
        getContentPane().add(l, BorderLayout.CENTER);
        // "Pack" the window
        pack();
        // Put the window to the center of the screen.
		setLocationRelativeTo(null);
    }
    
    
	/**
	* The main method.
	* @param argp The String array which stores the 
	* console commands, if one of them is <code>-nowait</code>,
	* then the program will be executed in "nowait" mode.
	*/
    public static void main(String[] argp) {
    	
    	// Set nowait to false
    	nowait = false;
    	
    	// If there are some command-line arguments
    	if (argp.length > 0) {
    		// For each argument
    		for (String s: argp)
    			// If the argument is -nowait (Not case-sensitive)
    			if(s.equalsIgnoreCase("-nowait")) {
    				// Then set nowait to true
    				nowait = true;
    				// No need to check the rest, break
    				break;
    			}
    	}
    	
    	// Create a new Splash window
		Splash spl = new Splash("images/gui/Splash.jpg");
		// Make the window visible
    	spl.setVisible(true);
    	
    	// If nowait mode is off
    	if (!nowait)
    		// Wait 2 seconds.
	    	AnimatedNotifier.wait(2000);
    	
    	// Dispose splash screen
		spl.dispose();
		
		// Create a new Display screen.
		new Display();
		
    	// Initialize the ReadingDuration class
    	ReadingDuration.initialize();
    }
    
    /**
     * <code>isNoWait</code><br>
     * Returns nowait boolean, which is a boolean value, 
     * read by the main method from the console to 
     * determine whether the animations will be skipped 
     * or not in order to gain more speed.
     * @return The nowait boolean.
     */
    public static boolean isNoWait() {
    	// Return the nowait boolean
    	return nowait;
    }
}