/**
 * @(#)ThemeGallery.java
 *
 * The ThemeGallery class to let the user 
 * select a theme using a nice screen.
 * This class extends the abstract Gallery class.
 *
 * @see Gallery
 * @author Onur Erdem
 * @version 1.00 21.12.2009
 */

package bin;
 
import java.awt.Font;
import java.awt.Color;

public class ThemeGallery extends Gallery {
	
	/**
	 * <code>serialVersionUID</code><br>
	 * Created by Eclipse.
	 */
	private static final long serialVersionUID = -6257997359303663533L;

	/**
	 * <code>d</code><br>
	 * The reference to the Display object.
	 */
	private Display d;
	
	/**
	 * <code>c</code><br>
	 * The reference to the Configurations object.
	 */
	private Configurations c;
	
	/**
	 * <code>themes</code><br>
	 * The theme list used for creating the gallery.
	 */
	private static final Theme[] themes = new Theme[] {
		new Theme("Default",new Font(Font.SANS_SERIF,Font.ITALIC,30),new Color(0.2f,0.2f,0.2f),Color.WHITE,"images/backgrounds/jLibris.jpg"),
		new Theme("Dark Age",new Font(Font.SANS_SERIF,Font.ITALIC,30),new Color(0.4f,0.4f,0.4f),Color.BLACK,"images/backgrounds/monotonous.jpg"),
		new Theme("Parchment",new Font(Font.SERIF,Font.PLAIN,30),new Color(0.6f,0,0),Color.BLACK,"images/backgrounds/parchment.jpg"),
		new Theme("Blueness",new Font("Arial",Font.ITALIC,30),Color.WHITE,new Color(0,17,29),"images/backgrounds/sail_to_death.jpg")
	};
	
    /**
     * The constructor. Takes a Display and a Configurations class 
     * as an argument and uses them when a theme is clicked on to 
     * reload the Display object and see the change immediately.
	 * @param d The Display object.
	 * @param c The Configurations object.
	 */
	public ThemeGallery(Display d,Configurations c) {
		// Call the super constructor to create a "Themes" gallery
    	super(Language.getText(5),"themes",themes.length,77,179,255);
    	// Assign d
    	this.d = d;
    	// Assign c
    	this.c = c;
    }
    
    /**
	 * <code>onClick</code><br>
     * This method is called when a theme is selected.
     * It simply applies the theme.
     * @param i Index of the selected theme.
     */
	public void onClick(int i) {
		// Apply the selected theme
    	themes[i].applyTheme(d,c);
    	// Dispose the window
		dispose();
    }
    
    /**
     * <code>onMouseOver</code><br>
     * This method is called when a theme is hovered.
     * In this case, the name of the corresponding
     * theme is returned to be shown.
     * @param i Index of the hovered theme.
     */
	public String onMouseOver(int i) {
		// Return the theme's name
    	return themes[i].getName();
    }
}