package de.beagtex.control;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.CannotRedoException;

import de.beagtex.gui.Editor;

public class RedoAction extends AbstractAction {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	Editor editor;

	/**
	 * ConstruCtor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 */
	public RedoAction(Editor editor) {
		this.editor = editor;
		setEnabled(false);
	}

	public void actionPerformed(ActionEvent e) {

		actionPerformedEditor();
	}

	public void update() {

		updateEditor();
	}

	/**
	 * actionPerformed-Methode fr Editor
	 * 
	 */
	private void actionPerformedEditor() {

		try {
			editor.getUndoMan().redo();
		} catch (CannotRedoException ex) {
			System.err.println("Kein weiterer Redo mglich!");
		}
		update();
		editor.redoAction.update();
	}

	/**
	 * update-Methode fr Editor
	 * 
	 */
	private void updateEditor() {

		if (editor.getUndoMan().canRedo()) {
			setEnabled(true);
			putValue(Action.NAME, editor.getUndoMan().getRedoPresentationName());
			editor.getBFrame().getBlButtons().getSaveB().setEnabled(true);
		} else {
			setEnabled(false);
			putValue(Action.NAME, "Undo");
		}
	}

}
