package de.beagtex.gui;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

/**
 * Abstract class that provides Methods for all used Windows
 * 
 * @author Benjamin Haag
 */
public abstract class BWindow extends JFrame {

	/**
	 * Makes sure that a windows is displays at the middle of the screen
	 * 
	 * @param int
	 *            w: width
	 * @param int
	 *            h: height
	 */
	public void show(int w, int h) {
		// int w = 350, h = 80;
		if (w != -1 && h != -1) {
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
			// Bildschirmgre
			setBounds((d.width - w) / 2, (d.height - h) / 3, w, h);
			super.show();
		}
	}
}
