package de.beagtex.gui;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import de.beagtex.listener.control.CopyListener;
import de.beagtex.listener.control.CutListener;
import de.beagtex.listener.control.NewListener;
import de.beagtex.listener.control.PasteListener;
import de.beagtex.listener.control.SaveListener;
import de.beagtex.listener.format.BoldListener;
import de.beagtex.listener.format.ColorListener;
import de.beagtex.listener.format.ItalicListener;
import de.beagtex.listener.format.LeftListener;
import de.beagtex.listener.format.RightListener;
import de.beagtex.listener.format.UnderlineListener;
import de.beagtex.listener.format.CenteredListener;
import de.beagtex.listener.gui.OpenButtonListener;
import de.beagtex.listener.insert.BulletListener;

/**
 * Complete extension of JToolBar with preallocated Buttons. A ButtonBar has to
 * know its related BFrame in wich it is used
 * 
 * @author Benjamin Haag
 * 
 */
public class ButtonBar extends JToolBar {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * BFrame-Object
	 */
	private BFrame bFrame;

	/**
	 * Save-Button
	 */
	private JButton saveB;

	/**
	 * Constructor
	 * 
	 * @param pBFrame :
	 *            related BFrame
	 * @param pOrientation :
	 *            Horizontal oder Vertical?
	 */
	public ButtonBar(BFrame pBFrame, int pOrientation) {
		super(pOrientation);
		this.bFrame = pBFrame;
		createContent(this);
	}

	/**
	 * Creates the contend of the Button-Bar
	 * 
	 * @param pBL :
	 *            ButtonBar to be filled
	 */
	private void createContent(ButtonBar pBL) {

		Icon iconNew = new ImageIcon(BFrame.class
				.getResource("/icons/neukatha.gif"));
		JButton newB = new JButton(iconNew);
		newB.addActionListener(new NewListener(this.bFrame, false));
		newB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.new"));
		Icon iconOpen = new ImageIcon(BFrame.class
				.getResource("/icons/openkatha.gif"));
		JButton openB = new JButton(iconOpen);
		Icon iconSave = new ImageIcon(BFrame.class
				.getResource("/icons/savekatha.gif"));
		openB.addActionListener(new OpenButtonListener(this.bFrame.getEdit()));
		openB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.open"));
		saveB = new JButton(iconSave);
		saveB.addActionListener(new SaveListener(this.bFrame.getEdit()));
		saveB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.save"));
		Icon iconCopy = new ImageIcon(BFrame.class
				.getResource("/icons/copykatha2.gif"));
		JButton copyB = new JButton(iconCopy);
		copyB.addActionListener(new CopyListener(this.bFrame.getEdit()));
		copyB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.copy"));
		Icon iconPaste = new ImageIcon(BFrame.class
				.getResource("/icons/pastekatha.gif"));
		JButton pasteB = new JButton(iconPaste);
		pasteB.addActionListener(new PasteListener(this.bFrame.getEdit()));
		pasteB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.paste"));
		Icon iconCut = new ImageIcon(BFrame.class
				.getResource("/icons/cutkatha2.gif"));
		JButton cutB = new JButton(iconCut);
		cutB.addActionListener(new CutListener(this.bFrame.getEdit()));
		cutB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.cut"));
		Icon iconBold = new ImageIcon(BFrame.class
				.getResource("/icons/boldkatha.gif"));
		JButton fettB = new JButton(iconBold);
		fettB.addActionListener(new BoldListener(this.bFrame.getEdit()));
		fettB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.bold"));
		Icon iconItalic = new ImageIcon(BFrame.class
				.getResource("/icons/italickatha.gif"));
		JButton italicB = new JButton(iconItalic);
		italicB.addActionListener(new ItalicListener(this.bFrame.getEdit()));
		italicB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.italic"));
		Icon iconUnderlined = new ImageIcon(BFrame.class
				.getResource("/icons/underlinekatha.gif"));
		JButton underlineB = new JButton(iconUnderlined);
		underlineB.addActionListener(new UnderlineListener(this.bFrame
				.getEdit()));
		underlineB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.underline"));
		Icon iconLeft = new ImageIcon(BFrame.class
				.getResource("/icons/leftkatha.gif"));
		JButton leftB = new JButton(iconLeft);
		leftB.addActionListener(new LeftListener(this.bFrame.getEdit()));
		leftB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.left"));
		Icon iconCentered = new ImageIcon(BFrame.class
				.getResource("/icons/centerkatha.gif"));
		JButton centeredB = new JButton(iconCentered);
		centeredB
				.addActionListener(new CenteredListener(this.bFrame.getEdit()));
		centeredB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.centered"));
		Icon iconRight = new ImageIcon(BFrame.class
				.getResource("/icons/rightkatha.gif"));
		JButton rightB = new JButton(iconRight);
		rightB.addActionListener(new RightListener(this.bFrame.getEdit()));
		rightB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.right"));
		Icon iconBullets = new ImageIcon(BFrame.class
				.getResource("/icons/bulletskatha.gif"));
		JButton bulletB = new JButton(iconBullets);
		bulletB.addActionListener(new BulletListener(this.bFrame.getEdit()));
		bulletB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.listing"));
		Icon iconColor = new ImageIcon(BFrame.class
				.getResource("/icons/fgkatha.gif"));
		JButton colorB = new JButton(iconColor);
		colorB.addActionListener(new ColorListener(this.bFrame.getEdit()));
		colorB.setToolTipText(BFrame.get_prop().getProperty(
		 "beagtex.button.textcolor"));

		pBL.add(newB);
		pBL.add(openB);
		pBL.add(saveB);
		pBL.add(cutB);
		pBL.add(copyB);
		pBL.add(pasteB);
		pBL.add(fettB);
		pBL.add(italicB);
		pBL.add(underlineB);
		pBL.add(leftB);
		pBL.add(centeredB);
		pBL.add(rightB);
		pBL.add(bulletB);
		pBL.add(colorB);
	}

	// ab hier Getter/Setter
	public JButton getSaveB() {
		return saveB;
	}
}
