package de.beagtex.gui;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

import de.beagtex.listener.control.LanguageListener;
import de.beagtex.listener.control.StartNewListener;
import de.beagtex.listener.gui.MyWindowListener;

/**
 * Screen for Language-setting when starting BeaGTex for the first time
 * 
 * @author Benjamin Haag
 * 
 */
public class LanguageChoiceWindow extends BWindow {

	BFrame bFrame;
	JComboBox langChooser;

	/**
	 * Constructor
	 * 
	 * @param pBFrame :
	 *            the calling BFrame
	 */
	public LanguageChoiceWindow(BFrame pBFrame) {

		this.bFrame = pBFrame;
		paint();
	}

	/**
	 * Paints the Window
	 */
	public void paint() {
		setTitle("Please Choose a Language!");
		setSize(400, 150);
		// setLocation(200, 200);
		setResizable(false);
		this.addWindowListener(new MyWindowListener(bFrame));
		String[] langs = {"English", "German"};
		JPanel langChoice = new JPanel();
		langChooser = new JComboBox(langs);
		langChooser.addActionListener(new LanguageListener(bFrame, this));
		JLabel add = new JLabel("BeaGTex - Your LaTex-Editor");
		langChoice.add(langChooser);
		langChoice.add(add);
		setContentPane(langChoice);
	}

	// Getter / Setter
	public JComboBox getLangChooser() {
		return langChooser;
	}
}
