package de.beagtex.listener.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.undo.CannotUndoException;

import de.beagtex.gui.Editor;

/**
 * Listener for undo-actions
 * 
 * @author Benjamin Haag
 */
public class UndoListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param pEditor:
	 *            the calling editor-object
	 */
	public UndoListener(Editor pEditor) {
		this.editor = pEditor;
	}

	public void actionPerformed(ActionEvent arg0) {

		try {
			editor.undoAction.actionPerformed(arg0);
		} catch (CannotUndoException e) {
			System.err.println("No more undos possible!");
		}
	}

}
