package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for left-alignment in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class LeftListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public LeftListener(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\begin{flushleft}" + "\r\n" + "\r\n"
					+ "\\end{flushleft}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 16);
		} else {
			editor.insert("\\begin{flushleft}" + "\r\n", editor
					.getSelectionStart());
			editor.insert("\r\n" + "\\end{flushleft}" + "\r\n", editor
					.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}
}
