package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for inserting an empty page in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class EmptyPageListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public EmptyPageListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		editor.insert("\r\n" + "\\newpage" + "\r\n"
				+ "\\definecolor{weiss}{rgb}{1, 1, 1}" + "\r\n"
				+ "\\textcolor{weiss}{leerseite}" + "\r\n" + "\\newpage"
				+ "\r\n", editor.getCaretPosition());
		editor.requestFocus();
		editor.setCaretPosition(editor.getCaretPosition());
	}
}
