/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.ExtensionOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Options {
    private Hashtable extensionOptionsList = new Hashtable();
    private ExtensionOptions defaultExtensionOptions = null;
    private String fileName;
    private Properties options = new Properties();
    private Properties storedOptions = null;
    private Hashtable storedExtensionOptionsList;

    Options(String string) {
        this.setDefaults();
        this.fileName = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.options.load(fileInputStream);
            fileInputStream.close();
            this.storedOptions = (Properties)((Hashtable)this.options).clone();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buildExtensionOptions();
    }

    Options() {
        this.setDefaults();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(System.getProperty("file.separator"));
        stringBuffer.append(".cqoptions");
        if (!new File(stringBuffer.toString()).exists()) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(System.getProperty("user.home"));
            stringBuffer.append(System.getProperty("file.separator"));
            stringBuffer.append("cqoptions.ini");
        }
        this.fileName = stringBuffer.toString();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fileName);
            this.options.load(fileInputStream);
            fileInputStream.close();
            this.storedOptions = (Properties)((Hashtable)this.options).clone();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buildExtensionOptions();
    }

    public boolean isSearchCaseIndependent() {
        Boolean bl = new Boolean(this.options.getProperty("SEARCH_CASE_INDEPENDENT"));
        return bl;
    }

    public void setSearchCaseIndependent(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("SEARCH_CASE_INDEPENDENT", bl2.toString());
    }

    public boolean isDefaultTabCompression() {
        Boolean bl = new Boolean(this.options.getProperty("DEFAULT_TAB_COMPRESSION"));
        return bl;
    }

    public void setDefaultTabCompression(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("DEFAULT_TAB_COMPRESSION", bl2.toString());
    }

    public boolean isForceSpaceExpansion() {
        Boolean bl = new Boolean(this.options.getProperty("FORCE_SPACE_EXPANSION"));
        return bl;
    }

    public void setForceSpaceExpansion(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FORCE_SPACE_EXPANSION", bl2.toString());
    }

    public boolean isForceTabCompression() {
        Boolean bl = new Boolean(this.options.getProperty("FORCE_TAB_COMPRESSION"));
        return bl;
    }

    public void setForceTabCompression(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FORCE_TAB_COMPRESSION", bl2.toString());
    }

    public String getFontName() {
        return this.options.getProperty("FONT_NAME");
    }

    public void setFontName(String string) {
        ((Hashtable)this.options).put("FONT_NAME", string);
    }

    public int getFontPoint() {
        Integer n = new Integer(this.options.getProperty("FONT_POINT"));
        return n;
    }

    public void setFontPoint(int n) {
        Integer n2 = new Integer(this.options.getProperty("FONT_POINT"));
        ((Hashtable)this.options).put("FONT_POINT", Integer.toString(n));
    }

    public String getCommandLineFontName() {
        return this.options.getProperty("COMMAND_LINE_FONT_NAME");
    }

    public void setCommandLineFontName(String string) {
        ((Hashtable)this.options).put("COMMAND_LINE_FONT_NAME", string);
    }

    public int getCommandLineFontPoint() {
        Integer n = new Integer(this.options.getProperty("COMMAND_LINE_FONT_POINT"));
        return n;
    }

    public void setCommandLineFontPoint(int n) {
        Integer n2 = new Integer(this.options.getProperty("COMMAND_LINE_FONT_POINT"));
        ((Hashtable)this.options).put("COMMAND_LINE_FONT_POINT", Integer.toString(n));
    }

    public boolean isFontBold() {
        Boolean bl = new Boolean(this.options.getProperty("FONT_BOLD"));
        return bl;
    }

    public void setFontBold(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FONT_BOLD", bl2.toString());
    }

    public boolean isCommandLineFontBold() {
        Boolean bl = new Boolean(this.options.getProperty("COMMAND_LINE_FONT_BOLD"));
        return bl;
    }

    public void setCommandLineFontBold(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("COMMAND_LINE_FONT_BOLD", bl2.toString());
    }

    public boolean isPrintFontBold() {
        Boolean bl = new Boolean(this.options.getProperty("PRINT_FONT_BOLD"));
        return bl;
    }

    public void setPrintFontBold(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("PRINT_FONT_BOLD", bl2.toString());
    }

    public int getPrintFontPoint() {
        Integer n = new Integer(this.options.getProperty("PRINT_FONT_POINT"));
        return n;
    }

    public void setPrintFontPoint(int n) {
        Integer n2 = new Integer(this.options.getProperty("PRINT_FONT_POINT"));
        ((Hashtable)this.options).put("PRINT_FONT_POINT", Integer.toString(n));
    }

    public boolean isPrintFileName() {
        Boolean bl = new Boolean(this.options.getProperty("PRINT_FILE_NAME"));
        return bl;
    }

    public void setPrintFileName(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("PRINT_FILE_NAME", bl2.toString());
    }

    public boolean isPrintPageNumbers() {
        Boolean bl = new Boolean(this.options.getProperty("PRINT_PAGE_NUMBERS"));
        return bl;
    }

    public void setPrintPageNumbers(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("PRINT_PAGE_NUMBERS", bl2.toString());
    }

    public void setPrintTopMargin(double d) {
        ((Hashtable)this.options).put("PRINT_TOP_MARGIN", Double.toString(d));
    }

    public double getPrintTopMargin() {
        Double d = new Double(this.options.getProperty("PRINT_TOP_MARGIN"));
        return d;
    }

    public void setPrintBottomMargin(double d) {
        ((Hashtable)this.options).put("PRINT_BOTTOM_MARGIN", Double.toString(d));
    }

    public double getPrintBottomMargin() {
        Double d = new Double(this.options.getProperty("PRINT_BOTTOM_MARGIN"));
        return d;
    }

    public void setPrintRightMargin(double d) {
        ((Hashtable)this.options).put("PRINT_RIGHT_MARGIN", Double.toString(d));
    }

    public double getPrintRightMargin() {
        Double d = new Double(this.options.getProperty("PRINT_RIGHT_MARGIN"));
        return d;
    }

    public void setPrintLineNumbers(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("PRINT_LINE_NUMBERS", bl2.toString());
    }

    public boolean isPrintLineNumbers() {
        Boolean bl = new Boolean(this.options.getProperty("PRINT_LINE_NUMBERS"));
        return bl;
    }

    public void setPrintLeftMargin(double d) {
        ((Hashtable)this.options).put("PRINT_LEFT_MARGIN", Double.toString(d));
    }

    public double getPrintLeftMargin() {
        Double d = new Double(this.options.getProperty("PRINT_LEFT_MARGIN"));
        return d;
    }

    public String getSyntaxFile() {
        return this.options.getProperty("SYNTAX_FILE");
    }

    public void setSyntaxFile(String string) {
        ((Hashtable)this.options).put("SYNTAX_FILE", string);
    }

    public int getDefaultHeight() {
        Integer n = new Integer(this.options.getProperty("DEFAULT_HEIGHT"));
        return n;
    }

    public void setDefaultHeight(int n) {
        ((Hashtable)this.options).put("DEFAULT_HEIGHT", Integer.toString(n));
    }

    public int getDefaultWidth() {
        Integer n = new Integer(this.options.getProperty("DEFAULT_WIDTH"));
        return n;
    }

    public void setDefaultWidth(int n) {
        ((Hashtable)this.options).put("DEFAULT_WIDTH", Integer.toString(n));
    }

    public int getTabInterval() {
        Integer n = new Integer(this.options.getProperty("TAB_INTERVAL"));
        return n;
    }

    public void setTabInterval(int n) {
        ((Hashtable)this.options).put("TAB_INTERVAL", Integer.toString(n));
    }

    public boolean isAutoIndent() {
        Boolean bl = new Boolean(this.options.getProperty("AUTO_INDENT"));
        return bl;
    }

    public void setAutoIndent(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("AUTO_INDENT", bl2.toString());
    }

    public boolean isBackspaceTab() {
        Boolean bl = new Boolean(this.options.getProperty("BACKSPACE_TAB"));
        return bl;
    }

    public void setBackspaceTab(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("BACKSPACE_TAB", bl2.toString());
    }

    public boolean isStripEolSpaces() {
        Boolean bl = new Boolean(this.options.getProperty("STRIP_EOL_SPACES"));
        return bl;
    }

    public void setStripEolSpaces(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("STRIP_EOL_SPACES", bl2.toString());
    }

    public boolean isFileCaseSensitive() {
        Boolean bl = new Boolean(this.options.getProperty("FILE_CASE_SENSITIVE"));
        return bl;
    }

    public void setFileCaseSensitive(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("FILE_CASE_SENSITIVE", bl2.toString());
    }

    public boolean isEolIndependentCursor() {
        Boolean bl = new Boolean(this.options.getProperty("EOL_INDEPENDENT_CURSOR"));
        return bl;
    }

    public void setEolIndependentCursor(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        ((Hashtable)this.options).put("EOL_INDEPENDENT_CURSOR", bl2.toString());
    }

    public void setBackgroundColor(String string) {
        ((Hashtable)this.options).put("BACKGROUND_COLOR", string);
    }

    public void setTextColor(String string) {
        ((Hashtable)this.options).put("TEXT_COLOR", string);
    }

    public String getBackgroundColor() {
        return this.options.getProperty("BACKGROUND_COLOR");
    }

    public String getTextColor() {
        return this.options.getProperty("TEXT_COLOR");
    }

    public boolean save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
            this.options.save(fileOutputStream, "CodeQuill Options");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setDefaults() {
        ((Hashtable)this.options).put("FONT_NAME", "Monospaced");
        ((Hashtable)this.options).put("FONT_POINT", "14");
        ((Hashtable)this.options).put("FONT_BOLD", "true");
        ((Hashtable)this.options).put("COMMAND_LINE_FONT_NAME", "Monospaced");
        ((Hashtable)this.options).put("COMMAND_LINE_FONT_POINT", "14");
        ((Hashtable)this.options).put("COMMAND_LINE_FONT_BOLD", "true");
        ((Hashtable)this.options).put("DEFAULT_TAB_COMPRESSION", "false");
        ((Hashtable)this.options).put("TAB_INTERVAL", "4");
        ((Hashtable)this.options).put("FORCE_SPACE_EXPANSION", "false");
        ((Hashtable)this.options).put("FORCE_TAB_COMPRESSION", "false");
        ((Hashtable)this.options).put("SYNTAX_FILE", "cqsyntax");
        ((Hashtable)this.options).put("DEFAULT_WIDTH", "600");
        ((Hashtable)this.options).put("DEFAULT_HEIGHT", "400");
        ((Hashtable)this.options).put("AUTO_INDENT", "true");
        ((Hashtable)this.options).put("BACKSPACE_TAB", "true");
        ((Hashtable)this.options).put("STRIP_EOL_SPACES", "true");
        ((Hashtable)this.options).put("SEARCH_CASE_INDEPENDENT", "false");
        ((Hashtable)this.options).put("EOL_INDEPENDENT_CURSOR", "false");
        ((Hashtable)this.options).put("BACKGROUND_COLOR", "Default");
        ((Hashtable)this.options).put("TEXT_COLOR", "Default");
        ((Hashtable)this.options).put("PRINT_FONT_POINT", "14");
        ((Hashtable)this.options).put("PRINT_FONT_BOLD", "false");
        ((Hashtable)this.options).put("PRINT_FILE_NAME", "true");
        ((Hashtable)this.options).put("PRINT_PAGE_NUMBERS", "true");
        ((Hashtable)this.options).put("PRINT_TOP_MARGIN", Double.toString(0.25));
        ((Hashtable)this.options).put("PRINT_BOTTOM_MARGIN", Double.toString(0.5));
        ((Hashtable)this.options).put("PRINT_LEFT_MARGIN", Double.toString(0.25));
        ((Hashtable)this.options).put("PRINT_RIGHT_MARGIN", Double.toString(0.25));
        ((Hashtable)this.options).put("PRINT_LINE_NUMBERS", "false");
        String string = System.getProperty("os.name");
        if (string.compareTo("Windows NT") == 0 || string.compareTo("Windows 95") == 0 || string.compareTo("OS/2") == 0) {
            ((Hashtable)this.options).put("FILE_CASE_SENSITIVE", "false");
        } else {
            ((Hashtable)this.options).put("FILE_CASE_SENSITIVE", "true");
        }
    }

    public Enumeration getSyntaxExtensionList() {
        return this.extensionOptionsList.keys();
    }

    public void setSyntaxFileName(String string) {
        this.defaultExtensionOptions.setSyntaxFileName(string);
        ((Hashtable)this.options).put("SYNTAX_FILE", string);
    }

    public void setSyntaxFileName(String string, String string2) {
        ExtensionOptions extensionOptions = (ExtensionOptions)this.extensionOptionsList.get(string.toLowerCase());
        if (extensionOptions != null) {
            extensionOptions.setSyntaxFileName(string2);
            ((Hashtable)this.options).put("SYNTAX_FILE_".concat(string.toUpperCase()), string2);
        }
    }

    public String getSyntaxFileName() {
        return this.defaultExtensionOptions.getSyntaxFileName();
    }

    public String getSyntaxFileName(String string) {
        ExtensionOptions extensionOptions = (ExtensionOptions)this.extensionOptionsList.get(string.toLowerCase());
        if (extensionOptions == null) {
            return null;
        }
        return extensionOptions.getSyntaxFileName();
    }

    public void addFileNameExtension(String string) {
        this.extensionOptionsList.put(string.toLowerCase(), new ExtensionOptions());
    }

    public void deleteFileNameExtension(String string) {
        this.extensionOptionsList.remove(string.toLowerCase());
        ((Hashtable)this.options).remove("SYNTAX_FILE_".concat(string.toUpperCase()));
    }

    private void buildExtensionOptions() {
        this.defaultExtensionOptions = new ExtensionOptions();
        this.defaultExtensionOptions.setSyntaxFileName(this.options.getProperty("SYNTAX_FILE"));
        Enumeration<?> enumeration = this.options.propertyNames();
        this.extensionOptionsList.clear();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("SYNTAX_FILE_") || (string = string.trim()).equals("SYNTAX_FILE_")) continue;
            String string2 = string.substring(12);
            ExtensionOptions extensionOptions = new ExtensionOptions(string2);
            extensionOptions.setSyntaxFileName(this.options.getProperty(string));
            this.extensionOptionsList.put(string2.toLowerCase(), extensionOptions);
        }
    }

    public void storeOptions() {
        this.storedOptions = this.options;
        this.options = (Properties)((Hashtable)this.storedOptions).clone();
    }

    public void restoreOptions() {
        this.options = this.storedOptions;
        this.buildExtensionOptions();
    }
}

