/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

class PrintService {
    private Dimension pageDimension = null;
    private int pixelsPerInch = 0;
    private Font defaultFont = new Font("Courier", 0, 10);
    private FontMetrics fontMetrics = null;
    private int fontHeight = 0;
    private int fontDescent = 0;
    private int fontAscent = 0;
    private double topMargin = 0.0;
    private double bottomMargin = 0.0;
    private double leftMargin = 0.0;
    private double rightMargin = 0.0;
    private boolean printPageNumber = false;
    private boolean printJobName = false;
    private int pageNumber = 1;
    Graphics printGraphics = null;
    PrintJob printJob;
    String jobName = null;

    public void setFont(Font font) {
        this.defaultFont = font;
    }

    public void enablePageNumbers(boolean bl) {
        this.printPageNumber = bl;
    }

    public void enableJobName(boolean bl) {
        this.printJobName = bl;
    }

    protected int getVerticalPos(int n) {
        int n2 = this.fontAscent + this.fontHeight * n + this.getTopMarginOffset();
        if (this.printJobName && this.jobName.length() > 0) {
            n2 += this.fontHeight * 2;
        }
        return n2;
    }

    protected int getVerticalPos(double d) {
        int n = this.getOffset(d) + this.getTopMarginOffset() - this.fontDescent;
        if (this.printJobName) {
            n += this.fontHeight;
        }
        return n;
    }

    protected int getHorizontalPos(double d) {
        int n = this.getOffset(d) + this.getLeftMarginOffset();
        return n;
    }

    protected int getCenterPos(String string) {
        int n = this.fontMetrics.stringWidth(string);
        int n2 = (this.pageDimension.width - this.getLeftMarginOffset() - this.getRightMarginOffset()) / 2 - n / 2;
        return n2 += this.getRightMarginOffset();
    }

    protected int getRightJustifiedOffset(String string, double d) {
        int n = this.fontMetrics.stringWidth(string);
        int n2 = this.getHorizontalPos(d) - n;
        return n2;
    }

    protected void printHeader(Graphics graphics) {
        if (this.printPageNumber && this.printJobName && this.jobName.length() > 0) {
            graphics.drawString(this.jobName + " (" + Integer.toString(this.pageNumber) + ")", this.getCenterPos(this.jobName + "(" + Integer.toString(this.pageNumber) + ")"), this.getTopMarginOffset() + this.fontAscent);
        } else if (this.printJobName && this.jobName.length() > 0) {
            graphics.drawString(this.jobName, this.getCenterPos(this.jobName), this.getTopMarginOffset() + this.fontAscent);
        }
    }

    protected void printPageNumber(Graphics graphics) {
        if (this.printPageNumber && (!this.printJobName || this.jobName.length() == 0)) {
            graphics.drawString("-" + Integer.toString(this.pageNumber) + "-", this.getCenterPos("-" + Integer.toString(this.pageNumber) + "-"), this.pageDimension.height - this.getBottomMarginOffset() - this.fontDescent);
        }
    }

    protected void setPageNumber(int n) {
        this.pageNumber = n;
    }

    protected void drawLine(String string, int n) {
        this.drawString(string, this.getLeftMarginOffset(), this.getVerticalPos(n));
    }

    protected void drawLine(String string, int n, int n2) {
        this.drawString(string, this.getLeftMarginOffset() + n2, this.getVerticalPos(n));
    }

    protected int getNumberOfLines() {
        int n = (this.pageDimension.height - this.getTopMarginOffset() - this.getBottomMarginOffset()) / this.fontHeight;
        if (this.printJobName && this.jobName.length() > 0 || this.printPageNumber) {
            n -= 2;
        }
        return n;
    }

    private int getBottomMarginOffset() {
        int n = (int)(this.bottomMargin * (double)this.pixelsPerInch);
        return n;
    }

    private int getTopMarginOffset() {
        int n = (int)(this.topMargin * (double)this.pixelsPerInch);
        return n;
    }

    private int getRightMarginOffset() {
        int n = (int)(this.rightMargin * (double)this.pixelsPerInch);
        return n;
    }

    private int getLeftMarginOffset() {
        int n = (int)(this.leftMargin * (double)this.pixelsPerInch);
        return n;
    }

    private int getOffset(double d) {
        int n = (int)(d * (double)this.pixelsPerInch);
        return n;
    }

    private int getPageNumberOffset() {
        return this.fontDescent + this.fontHeight;
    }

    protected int getStringWidth(String string) {
        return this.fontMetrics.stringWidth(string);
    }

    public boolean startPrintJob(Frame frame, String string) {
        Properties properties = new Properties();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(frame, string, properties);
        if (printJob == null) {
            return false;
        }
        this.setupPrintJob(printJob);
        this.jobName = string;
        return true;
    }

    protected int getPrintableAreaWidth() {
        return this.pageDimension.width - this.getLeftMarginOffset() - this.getRightMarginOffset();
    }

    protected int getPrintableAreaHeight() {
        return this.pageDimension.height - this.getTopMarginOffset() - this.getBottomMarginOffset();
    }

    public void endPrintJob() {
        this.printHeader(this.printGraphics);
        this.printPageNumber(this.printGraphics);
        this.printGraphics.dispose();
        this.printJob.end();
    }

    public void formFeed() {
        this.printHeader(this.printGraphics);
        this.printPageNumber(this.printGraphics);
        ++this.pageNumber;
        this.printGraphics.dispose();
        this.printGraphics = this.printJob.getGraphics();
        this.printGraphics.setFont(this.defaultFont);
        this.printGraphics.setColor(Color.black);
        this.fontMetrics = this.printGraphics.getFontMetrics(this.defaultFont);
    }

    public void drawString(String string, int n, int n2) {
        this.printGraphics.drawString(string, n, n2);
    }

    private void setupPrintJob(PrintJob printJob) {
        this.printJob = printJob;
        this.printGraphics = printJob.getGraphics();
        if (this.printGraphics == null) {
            return;
        }
        this.pixelsPerInch = 72;
        this.printGraphics.setFont(this.defaultFont);
        this.printGraphics.setColor(Color.black);
        this.pageDimension = printJob.getPageDimension();
        this.fontMetrics = this.printGraphics.getFontMetrics(this.defaultFont);
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontDescent = this.fontMetrics.getDescent();
        this.fontAscent = this.fontMetrics.getAscent();
    }

    public void setTopMargin(double d) {
        this.topMargin = d;
    }

    public void setBottomMargin(double d) {
        this.bottomMargin = d;
    }

    public void setLeftMargin(double d) {
        this.leftMargin = d;
    }

    public void setRightMargin(double d) {
        this.rightMargin = d;
    }
}

