package neutrino.autocomplete;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class TagChild {

    public static final int ONLY_ONE = 1;
    public static final int ZERO_OR_ONE = 2;
    public static final int ZERO_OR_MORE = 3;
    public static final int ONE_OR_MORE = 4;

    private int multiplicity;
    private String name;

    public TagChild(String tag) {
        char lastChar = tag.charAt(tag.length() - 1);
        if (lastChar == '?') this.multiplicity = ZERO_OR_ONE;
        else if (lastChar == '*') this.multiplicity = ZERO_OR_MORE;
        else if (lastChar == '+') this.multiplicity = ONE_OR_MORE;
        else this.multiplicity = ONLY_ONE;
        if (!Character.isLetter(lastChar)) name = tag.substring(0, tag.length() - 1);
        else name = tag;
    }

    public String getName() {
        return this.name;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

}