package neutrino.dialogs;

import java.awt.print.PrinterException;
import java.io.File;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

import neutrino.multitext.EditorAdapterFactory;
import neutrino.multitext.EditorType;
import neutrino.multitext.MultiTextComponent;
import neutrino.multitext.TextEditorAdapter;
import neutrino.text.ITextComponent;
import neutrino.text.TextEditor;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class ActionPerformer {
	
	private class ActionPerformingDialog extends JDialog implements ActionListener {
		
		protected JList lTexts = new JList();
		private JButton bPerform = new JButton("Perform");
		private JButton bSelect = new JButton("Select");
		private JButton bClose = new JButton("Close");
        private int currentIndex = 0;
        private MultiTextComponent multiTextComponent = null;
		private ArrayList<TextEditor> texts = null;
		private ArrayList<TextEditor> selectedTexts = null;
        private JPopupMenu popupMenuPerforming = new JPopupMenu();
        private JMenuItem miNew = new JMenuItem("New");
        private JMenuItem miOpen = new JMenuItem("Open...");
        private JMenuItem miReload = new JMenuItem("Reload");
        private JMenuItem miSave = new JMenuItem("Save");
        private JMenuItem miSaveAs = new JMenuItem("Save As...");
        private JMenuItem miPrint = new JMenuItem("Print...");
        private JMenuItem miCopy = new JMenuItem("Copy...");
        private JMenuItem miMove = new JMenuItem("Move...");
        private JMenuItem miRemove = new JMenuItem("Remove");
        private JMenuItem miRename = new JMenuItem("Rename...");
        private JMenuItem miRevert = new JMenuItem("Revert");
        private JMenuItem miChange = new JMenuItem("Change...");
        private JMenuItem miClose = new JMenuItem("Close");
        private JMenuItem miHidePerforming = new JMenuItem("Hide");
        private JPopupMenu popupMenuSelecting = new JPopupMenu();
        private JMenuItem miSelectNone = new JMenuItem("None");
        private JMenuItem miSelectAll = new JMenuItem("All");
        private JMenuItem miSelectCurrent = new JMenuItem("Current");
        private JMenuItem miSelectOthers = new JMenuItem("Others");
        private JMenuItem miSelectModified = new JMenuItem("Modified");
        private JMenuItem miSelectUnloaded = new JMenuItem("Unloaded");
        private JMenuItem miSelectReplaced = new JMenuItem("Replaced");
        private JMenuItem miHideSelecting = new JMenuItem("Hide");
		protected int option = JOptionPane.CANCEL_OPTION;
		protected ListModel listModel = new ListModel() {

			public void addListDataListener(ListDataListener l) { }

			public Object getElementAt(int index) {
                if (texts.get(index).isFileLoaded()) {
				    return texts.get(index).getFile().getName();
                } else {
                    return MultiTextComponent.createTitleForTextComponent(texts.get(index));
                }
			}

			public int getSize() {
				return texts.size();
			}

			public void removeListDataListener(ListDataListener l) { }
			
		};
        protected class TextsListCellRenderer extends JLabel implements ListCellRenderer {

            public TextsListCellRenderer() {
                setOpaque(true);
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                if (texts.get(index).isFileLoaded()) {
                    File file = texts.get(index).getFile();
                    text = file.getName();
                    setToolTipText(file.getAbsolutePath());
                } else {
                    text = MultiTextComponent.createTitleForTextComponent(texts.get(index));
                    setToolTipText("The text is without the file");
                }
                setText(text);
                if (isSelected) {
                    setForeground(list.getSelectionForeground());
                    setBackground(list.getSelectionBackground());
                } else {
                    setForeground(list.getForeground());
                    setBackground(list.getBackground());
                }
                return this;
            }

        }

        private void buildPerformingPopupMenu() {
            popupMenuPerforming.add(miNew);
            popupMenuPerforming.add(miOpen);
            popupMenuPerforming.add(miReload);
            popupMenuPerforming.add(miSave);
            popupMenuPerforming.add(miSaveAs);
            popupMenuPerforming.add(miPrint);
            popupMenuPerforming.add(miCopy);
            popupMenuPerforming.add(miMove);
            popupMenuPerforming.add(miRemove);
            popupMenuPerforming.add(miRename);
            popupMenuPerforming.add(miRevert);
            popupMenuPerforming.add(miChange);
            popupMenuPerforming.add(miClose);
            popupMenuPerforming.addSeparator();
            popupMenuPerforming.add(miHidePerforming);
        }

        private void buildPerformingPopupMenuMnemonics() {
            miNew.setMnemonic(KeyEvent.VK_N);
            miOpen.setMnemonic(KeyEvent.VK_O);
            miReload.setMnemonic(KeyEvent.VK_R);
            miSave.setMnemonic(KeyEvent.VK_S);
            miSaveAs.setMnemonic(KeyEvent.VK_A);
            miPrint.setMnemonic(KeyEvent.VK_P);
            miCopy.setMnemonic(KeyEvent.VK_C);
            miMove.setMnemonic(KeyEvent.VK_M);
            miRemove.setMnemonic(KeyEvent.VK_E);
            miRename.setMnemonic(KeyEvent.VK_M);
            miRevert.setMnemonic(KeyEvent.VK_V);
            miChange.setMnemonic(KeyEvent.VK_H);
            miClose.setMnemonic(KeyEvent.VK_L);
            miHidePerforming.setMnemonic(KeyEvent.VK_H);
        }

        private void buildPerformingPopupMenuToolTips() {
            miNew.setToolTipText("Clear the text");
            miOpen.setToolTipText("Open the file");
            miReload.setToolTipText("Reload the file");
            miSave.setToolTipText("Save the text in file");
            miSaveAs.setToolTipText("Save the text in another file");
            miPrint.setToolTipText("Print the text");
            miCopy.setToolTipText("Copy the file in another place");
            miMove.setToolTipText("Move the file");
            miRemove.setToolTipText("Remove the file");
            miRename.setToolTipText("Rename the file");
            miRevert.setToolTipText("Revert the text changes");
            miChange.setToolTipText("Change the editor");
            miClose.setToolTipText("Close the tab");
            miHidePerforming.setToolTipText("Hide performing menu");
        }

        private void buildPerformingPopupMenuActions() {
            miNew.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canClear()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.clear();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miOpen.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        multiTextComponent.activateTab(textEditor);
                        textEditor.open();
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miReload.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canReload()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.reload();
                        }
                    }
                }
            });
            miSave.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canSave()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.save();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miSaveAs.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canSaveAs()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.saveAs();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miPrint.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.getTextComponent() instanceof ITextComponent) {
                            ITextComponent textComponent = (ITextComponent) textEditor.getTextComponent();
                            if (textComponent.canPrint()) {
                                multiTextComponent.activateTab(textEditor);
                                try {
                                    textEditor.getTextComponent().print();
                                } catch (PrinterException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            multiTextComponent.activateTab(textEditor);
                            try {
                                textEditor.getTextComponent().print();
                            } catch (PrinterException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            miCopy.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canCopy()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.copy();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miMove.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canMove()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.move();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miRemove.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canRemove()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.remove();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miRename.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.canRename()) {
                            multiTextComponent.activateTab(textEditor);
                            textEditor.rename();
                        }
                    }
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
            miRevert.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        if (textEditor.getTextComponent() instanceof ITextComponent) {
                            ITextComponent textComponent = (ITextComponent) textEditor.getTextComponent();
                            if (textComponent.canRevert()) {
                                multiTextComponent.activateTab(textEditor);
                                textComponent.revert();
                            }
                        }
                    }
                }
            });
            miChange.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        multiTextComponent.activateTab(textEditor);
                        if (!textEditor.isTextSaved()) return;
                        EditorType editorType = EditorChooser.showChangeEditorDialog();
                        TextEditorAdapter adapter = EditorAdapterFactory.createTextEditorAdapterForEditorType(editorType);
                        if (editorType != null) multiTextComponent.replaceEditor(adapter);
                    }
                }
            });
            miClose.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    for (int i = 0; i < indices.length; i++) {
                        TextEditor textEditor = texts.get(indices[i]);
                        multiTextComponent.activateTab(textEditor);
                        if (multiTextComponent.canClose()) {
                            multiTextComponent.close();
                        }
                    }
                    texts = new ArrayList<TextEditor>();
                    TextEditor[] array = multiTextComponent.getTextEditors();
                    for (int i = 0; i < array.length ; i++) texts.add(array[i]);
                    setCurrentIndex();
                    lTexts.revalidate();
                    lTexts.repaint();
                }
            });
        }

        private void buildSelectingPopupMenu() {
            popupMenuSelecting.add(miSelectNone);
            popupMenuSelecting.add(miSelectAll);
            popupMenuSelecting.add(miSelectCurrent);
            popupMenuSelecting.add(miSelectOthers);
            popupMenuSelecting.add(miSelectModified);
            popupMenuSelecting.add(miSelectUnloaded);
            popupMenuSelecting.add(miSelectReplaced);
            popupMenuSelecting.addSeparator();
            popupMenuSelecting.add(miHideSelecting);
        }

        private void buildSelectingPopupMenuMnemonics() {
            miSelectNone.setMnemonic(KeyEvent.VK_N);
            miSelectAll.setMnemonic(KeyEvent.VK_A);
            miSelectCurrent.setMnemonic(KeyEvent.VK_C);
            miSelectOthers.setMnemonic(KeyEvent.VK_O);
            miSelectModified.setMnemonic(KeyEvent.VK_M);
            miSelectUnloaded.setMnemonic(KeyEvent.VK_U);
            miSelectReplaced.setMnemonic(KeyEvent.VK_R);
            miHideSelecting.setMnemonic(KeyEvent.VK_H);
        }

        private void buildSelectingPopupMenuToolTips() {
            miSelectNone.setToolTipText("Deselect the list");
            miSelectAll.setToolTipText("Select all editors");
            miSelectCurrent.setToolTipText("Select the current editor");
            miSelectOthers.setToolTipText("Select all editor but the selected previously");
            miSelectModified.setToolTipText("Select all editors where the text is changed");
            miSelectUnloaded.setToolTipText("Select all editors where the if is not loaded");
            miSelectReplaced.setToolTipText("Select all editors where the file is different from the edited text");
            miHideSelecting.setToolTipText("Hide selection menu");
        }

        private void buildSelectingPopupMenuActions() {
            miSelectNone.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    lTexts.getSelectionModel().clearSelection();
                }
            });
            miSelectAll.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    lTexts.setSelectionInterval(0, texts.size() - 1);
                }
            });
            miSelectCurrent.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    lTexts.setSelectedIndex(texts.indexOf(multiTextComponent.getCurrentTextEditor()));
                }
            });
            miSelectOthers.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] indices = lTexts.getSelectedIndices();
                    int[] newIndices = new int[texts.size() - indices.length];
                    int p = 0;
                    top : for (int i = 0; i < texts.size(); i++) {
                        for (int n = 0; n < indices.length; n++) {
                            if (indices[n] == i) continue top;
                        }
                        if (p < newIndices.length) { // test
                            newIndices[p] = i;
                            p++;
                        }
                    }
                    lTexts.setSelectedIndices(newIndices);
                }
            });
            miSelectModified.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int size = 0;
                    for (int i = 0; i < texts.size(); i++) {
                        if (texts.get(i).getTextComponent() instanceof ITextComponent) {
                            ITextComponent textComponent = (ITextComponent) texts.get(i).getTextComponent();
                            if (textComponent.isTextChanged()) size++;
                        }
                    }
                    int[] indices = new int[size];
                    int position = 0;
                    for (int i = 0; i < texts.size(); i++) {
                        if (texts.get(i).getTextComponent() instanceof ITextComponent) {
                            ITextComponent textComponent = (ITextComponent) texts.get(i).getTextComponent();
                            if (textComponent.isTextChanged()) {
                                indices[position] = i;
                                position++;
                            }
                        }
                    }
                    lTexts.setSelectedIndices(indices);
                }
            });
            miSelectUnloaded.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int size = 0;
                    for (int i = 0; i < texts.size(); i++) {
                        if (!texts.get(i).isFileLoaded()) size++;
                    }
                    int[] indices = new int[size];
                    int position = 0;
                    for (int i = 0; i < texts.size(); i++) {
                        if (!texts.get(i).isFileLoaded()) {
                            indices[position] = i;
                            position++;
                        }
                    }
                    lTexts.setSelectedIndices(indices);
                }
            });
            miSelectReplaced.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int size = 0;
                    for (int i = 0; i < texts.size(); i++) {
                        if (texts.get(i).isFileChanged()) size++;
                    }
                    int[] indices = new int[size];
                    int position = 0;
                    for (int i = 0; i < texts.size(); i++) {
                        if (texts.get(i).isFileChanged()) {
                            indices[position] = i;
                            position++;
                        }
                    }
                    lTexts.setSelectedIndices(indices);
                }
            });
            miHideSelecting.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    popupMenuSelecting.setVisible(false);
                }
            });
        }

        private void setCurrentIndex() {
            TextEditorAdapter[] adapters = multiTextComponent.getTextEditorAdapters();
            for (int i = 0; i < adapters.length; i++) {
                if (adapters[i] == multiTextComponent.getCurrentEditorAdapter()) {
                    currentIndex = i;
                    break;
                }
            }
        }

        private void revalidate() {
            texts = new ArrayList<TextEditor>();
            TextEditor[] array = multiTextComponent.getTextEditors();
            for (int i = 0; i < array.length ; i++) texts.add(array[i]);
            lTexts.revalidate();
            lTexts.repaint();
            lTexts.updateUI();
        }

		public ActionPerformingDialog(MultiTextComponent multiTextComponent) {
			super();
			setTitle("Perform action");
			setModal(false);
            setAlwaysOnTop(false);
			setResizable(false);
			getRootPane().setDefaultButton(bPerform);
			setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            this.multiTextComponent = multiTextComponent;

            revalidate();
            buildPerformingPopupMenu();
            buildPerformingPopupMenuMnemonics();
            buildPerformingPopupMenuToolTips();
            buildPerformingPopupMenuActions();
            buildSelectingPopupMenu();
            buildSelectingPopupMenuMnemonics();
            buildSelectingPopupMenuToolTips();
            buildSelectingPopupMenuActions();
            setCurrentIndex();

			lTexts.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			lTexts.setModel(listModel);
			Dimension size = new Dimension(400, 300);
			lTexts.setMinimumSize(size);
			lTexts.setPreferredSize(size);
			lTexts.setMaximumSize(size);
			lTexts.setSelectedIndex(currentIndex);
            lTexts.setCellRenderer(new TextsListCellRenderer());

			JPanel pEditors = new JPanel();
			pEditors.setBorder(new CompoundBorder(new TitledBorder("Editor"), new EmptyBorder(0, 5, 5, 5)));
			pEditors.setLayout(new BorderLayout());
			pEditors.add(new JScrollPane(lTexts), BorderLayout.CENTER);
			
			bPerform.setMnemonic(KeyEvent.VK_P);
			bSelect.setMnemonic(KeyEvent.VK_S);
			bClose.setMnemonic(KeyEvent.VK_C);
			
			bPerform.addActionListener(this);
			bSelect.addActionListener(this);
			bClose.addActionListener(this);

            bPerform.setToolTipText("Perform the action on selected editor");
            bSelect.setToolTipText("Select the editors from a menu");
            bClose.setToolTipText("Abort action performing dialog");
			
			GridBagLayout layout = new GridBagLayout();
			getContentPane().setLayout(layout);
			GridBagConstraints c = new GridBagConstraints();
			c.gridx = 0;
			c.gridy = 0;
			c.gridheight = 5;
			c.insets = new Insets(5, 5, 5, 0);
			getContentPane().add(pEditors, c);
			c.gridx = 1;
			c.gridy = 0;
			c.gridheight = 1;
			c.fill = GridBagConstraints.HORIZONTAL;
			c.insets = new Insets(10, 5, 0, 5);
			getContentPane().add(bPerform, c);
			c.gridy = 1;
			c.insets = new Insets(5, 5, 0, 5);
			getContentPane().add(bSelect, c);
			c.gridy = 2;
			getContentPane().add(bClose, c);
			pack();

            addWindowFocusListener(new WindowFocusListener() {
                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    revalidate();
                }
                @Override
                public void windowLostFocus(WindowEvent windowEvent) { }
            });
		}
		
		public int getOption() {
			return this.option;
		}
		
		public ArrayList<TextEditor> getTexts() {
			return selectedTexts;
		}

		@Override
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() == bPerform) {
                popupMenuPerforming.show(bPerform, bPerform.getWidth() / 2, bPerform.getHeight() / 2);
			} else if (e.getSource() == bSelect) {
				popupMenuSelecting.show(bSelect, bSelect.getWidth() / 2, bSelect.getHeight() / 2);
			} if (e.getSource() == bClose) {
				setVisible(false);
                dispose();
			}
		}
		
	}
	
	private static void establishBounds(JDialog dialog) {
        Dimension d1 = dialog.getSize();
        Dimension d2 = dialog.getToolkit().getScreenSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + 0, y + 0, d1.width, d1.height);
	}

    private static ActionPerformingDialog dialog = null;

	public static void showActionPerformingDialog(MultiTextComponent multiTextComponent) {
        if (dialog == null) {
            dialog = new ActionPerformer().new ActionPerformingDialog(multiTextComponent);
            establishBounds(dialog);
        }
        dialog.setVisible(true);
	}

}
