package neutrino.dialogs;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 * Dialog for choosing the directory
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class DirectoryChooser {

	public static File showDirectoryDialog(Component parent, File currentDir) {
		FileFilter directoryFilter = new FileFilter() {
			@Override
			public String getDescription() {
				return "Directories";
			}
			@Override
			public boolean accept(File dir) {
				if (dir.exists() && dir.isDirectory()) 
					return true;
				else 
					return false;
			}
		};
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setDialogTitle("Directory");
		fileChooser.setApproveButtonMnemonic(KeyEvent.VK_O);
		fileChooser.setApproveButtonToolTipText("Select Directory");
		fileChooser.setAcceptAllFileFilterUsed(false);
		fileChooser.setCurrentDirectory(currentDir);
		fileChooser.addChoosableFileFilter(directoryFilter);
		while (fileChooser.showDialog(parent, "Ok") == JFileChooser.APPROVE_OPTION) {
			File directory = fileChooser.getSelectedFile();
			if (!directory.exists() && !directory.isDirectory()) {
				JOptionPane.showMessageDialog(parent, "Selected directory does not exists", "Error", JOptionPane.ERROR_MESSAGE);
				continue;
			}
			return directory;
		}
		return null;
	}
	
}
