package neutrino.dialogs;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import static javax.swing.JOptionPane.*;

/**
 * Contains File rename dialog for changing file name
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 9/23/15
 * Time: 3:35 AM
 */
public class FileRenamer {

    private class FileRenameDialog extends JDialog implements ActionListener {

        private JLabel lFile = new JLabel();
        private JTextField tfFile = new JTextField(30);
        private JButton bOk = new JButton("Ok");
        private JButton bCancel = new JButton("Cancel");
        private File file;
        public File renamedFile = null;

        public FileRenameDialog( File file) {
            super();
            this.file = file;
            setTitle("Rename file");
            setModal(true);
            setResizable(false);
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            getContentPane().add(getMainPanel());
            pack();

        }

        private JPanel getMainPanel() {
            String fileName = file.getName();
            final int MAX_LENGTH = 15;
            if (fileName.length() > MAX_LENGTH) fileName = fileName.substring(0, MAX_LENGTH);
            lFile.setText("Rename file " + fileName + " to");
            lFile.setLabelFor(tfFile);
            lFile.setDisplayedMnemonic(KeyEvent.VK_R);
            tfFile.setText(file.getName());
            tfFile.selectAll();
            tfFile.grabFocus();
            JPanel panel = new JPanel();
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            GridBagLayout layout = new GridBagLayout();
            panel.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(0, 0, 5, 0);
            panel.add(lFile, c);
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = GridBagConstraints.WEST;
            c.insets = new Insets(0, 0, 5, 0);
            panel.add(tfFile, c);
            c.gridx = 0;
            c.gridy = 3;
            c.anchor = GridBagConstraints.EAST;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add(getButtonsPanel(), c);
            return panel;
        }

        private JPanel getButtonsPanel() {
            bOk.setMnemonic(KeyEvent.VK_O);
            bCancel.setMnemonic(KeyEvent.VK_C);
            bOk.setToolTipText("Rename file");
            bCancel.setToolTipText("Abort rename file dialog");
            this.getRootPane().setDefaultButton(bOk);
            bOk.addActionListener(this);
            bCancel.addActionListener(this);
            JPanel panel = new JPanel();
            BoxLayout layout = new BoxLayout(panel, BoxLayout.X_AXIS);
            panel.setLayout(layout);
            panel.add(Box.createHorizontalGlue());
            panel.add(bOk);
            panel.add(Box.createHorizontalStrut(5));
            panel.add(bCancel);
            return panel;
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == bOk || event.getSource() == bCancel) {
                if (event.getSource() == bOk) {
                    try {
                        String path = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - file.getName().length());
                        File newFile = new File(path + tfFile.getText());
                        boolean result = file.renameTo(newFile) ;
                        if (result) {
                            renamedFile = newFile;
                        } else {
                            showMessageDialog(this.getParent(), "Can not rename the file", "Error", ERROR_MESSAGE);
                        }
                    } catch (SecurityException e) {
                        showMessageDialog(this.getParent(), e.getMessage(), "Error", ERROR_MESSAGE);
                    }
                }
                setVisible(false);
                dispose();
            }
        }

    }

    private static void establishBounds(JDialog dialog) {
        Dimension d1 = dialog.getSize();
        Dimension d2 = dialog.getToolkit().getScreenSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + 0, y + 0, d1.width, d1.height);
    }

    /**
     * Shows "File rename" dialog for File
     * @param file - the file to rename
     */
    public static File showFileRenameDialog(File file) {
        if (file == null) {
            showMessageDialog(null, "File is not set", "Warning", WARNING_MESSAGE);
            return null;
        }
        FileRenamer fileRenamer = new FileRenamer();
        FileRenameDialog dialog = fileRenamer.new FileRenameDialog(file);
        establishBounds(dialog);
        dialog.setVisible(true);
        return dialog.renamedFile;
    }

}
