package neutrino.dialogs;

import neutrino.text.TextEditor;
import neutrino.text.components.plain.PlainTextArea;
import javax.swing.*;
import java.awt.*;
import java.io.File;

/**
 * Contains License dialog for viewing the license information
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 10/7/15
 * Time: 9:14 PM
 */
public class LicenseChooser {

    private class LicenseDialog extends JDialog {

        private int WIDTH = 700;
        private int HEIGHT = 700;
        private PlainTextArea textComponent;
        private TextEditor textEditor;
        private JScrollPane scrollPane;

        public LicenseDialog(JFrame owner, File licenseFile) {
            super(owner);
            setTitle("License");
            setSize(WIDTH, HEIGHT);
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            setModal(false);
            setAlwaysOnTop(false);
            setResizable(true);
            establishBounds(this);
            textComponent = new PlainTextArea();
            textComponent.setEditable(false);
            textComponent.setMargin(new Insets(20, 20, 20, 20));
            Font font = new Font(Font.MONOSPACED, Font.BOLD, 14);
            textComponent.setFont(font);
            scrollPane = new JScrollPane();
            scrollPane.getViewport().setView(textComponent);
            getContentPane().add(scrollPane);
            textEditor = new TextEditor(textComponent);
            if (textEditor.open(licenseFile)) {
                setVisible(true);
            };
        }

    }

    private static void establishBounds(JDialog dialog) {
        Dimension d1 = dialog.getSize();
        Dimension d2 = dialog.getToolkit().getScreenSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + 0, y + 0, d1.width, d1.height);
    }

    /**
     * Shows License dialog for JTextComponent
     * @param owner - the frame owner of dialog
     * @param licenseFile - the text file
     */
    public static void showLicenseDialog(JFrame owner, File licenseFile) {
        LicenseChooser licenseChooser = new LicenseChooser();
        LicenseDialog dialog = licenseChooser.new LicenseDialog(owner, licenseFile);
    }

}
