package neutrino.dialogs;

import neutrino.TextEditorWindow;
import javax.swing.*;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

/**
 * Menu for choosing the look and feel
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class LookAndFeelChooser {

    public class LookAndFeelMenuItem extends JRadioButtonMenuItem implements ActionListener {

        private String className;

        public LookAndFeelMenuItem(String name, String className) {
            super(name);
            this.className = className;
            addActionListener(this);
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            owner.setLookAndFeel(className);
        }

    }

    private JMenu menu;
    private ButtonGroup buttonGroup;
    private ArrayList<LookAndFeelMenuItem> menuItems;
    private TextEditorWindow owner;

    private LookAndFeelChooser(TextEditorWindow owner) {
        this.owner = owner;
        menu = new JMenu("Look And Feel");
        menu.addMenuListener(menuListener);
        buttonGroup = new ButtonGroup();
        menuItems = new ArrayList<LookAndFeelMenuItem>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            LookAndFeelMenuItem menuItem = new LookAndFeelMenuItem(info.getName(), info.getClassName());
            buttonGroup.add(menuItem);
            menuItems.add(menuItem);
            if (info.getClassName().equals(UIManager.getLookAndFeel().getClass().getCanonicalName())) {
                buttonGroup.setSelected(menuItem.getModel(), true);
            }
            menu.add(menuItem);
        }
    }

    private MenuListener menuListener = new MenuListener() {

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            for (LookAndFeelMenuItem menuItem : menuItems) {
                if (menuItem.getClassName().equals(UIManager.getLookAndFeel().getClass().getCanonicalName())) {
                    buttonGroup.setSelected(menuItem.getModel(), true);
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) { }

        @Override
        public void menuCanceled(MenuEvent menuEvent) { }

    };

    public static JMenu createLookAndFeelMenu(TextEditorWindow owner) {
        LookAndFeelChooser chooser = new LookAndFeelChooser(owner);
        return chooser.menu;
    }

}
