package neutrino.dialogs;

import neutrino.multitext.MultiTextComponent;

import javax.swing.*;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import java.awt.event.*;

/**
 * Chooser of theme for XML component.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class ThemeChooser {

    private JMenu menu = new JMenu("Theme");
    private JRadioButtonMenuItem miDefault = new JRadioButtonMenuItem("Default");
    private JRadioButtonMenuItem miBlack = new JRadioButtonMenuItem("Black");
    private JRadioButtonMenuItem miBlueprint = new JRadioButtonMenuItem("Blueprint");
    private JRadioButtonMenuItem miDark = new JRadioButtonMenuItem("Dark");
    private JRadioButtonMenuItem miEclipse = new JRadioButtonMenuItem("Eclipse");
    private JRadioButtonMenuItem miIdea = new JRadioButtonMenuItem("IDEA");
    private JRadioButtonMenuItem miVS = new JRadioButtonMenuItem("Visual Studio");
    private ButtonGroup buttonGroup = new ButtonGroup();
    private MultiTextComponent multiTextComponent;

    private ThemeChooser(MultiTextComponent multiTextComponent) {
        this.multiTextComponent = multiTextComponent;
        menu.addMenuListener(menuListener);
        buildMenu();
        buildMnemonics();
        buildButtonGroup();
        buildActions();
    }

    private void buildMenu() {
        menu.add(miDefault);
        menu.add(miBlack);
        menu.add(miBlueprint);
        menu.add(miDark);
        menu.add(miEclipse);
        menu.add(miIdea);
        menu.add(miVS);
    }

    private void buildMnemonics() {
        miDefault.setMnemonic(KeyEvent.VK_D);
        miBlack.setMnemonic(KeyEvent.VK_A);
        miBlueprint.setMnemonic(KeyEvent.VK_B);
        miDark.setMnemonic(KeyEvent.VK_A);
        miEclipse.setMnemonic(KeyEvent.VK_E);
        miIdea.setMnemonic(KeyEvent.VK_I);
        miVS.setMnemonic(KeyEvent.VK_V);
    }

    private void buildButtonGroup() {
        buttonGroup.add(miDefault);
        buttonGroup.add(miBlack);
        buttonGroup.add(miBlueprint);
        buttonGroup.add(miDark);
        buttonGroup.add(miEclipse);
        buttonGroup.add(miIdea);
        buttonGroup.add(miVS);
        buttonGroup.setSelected(miDefault.getModel(), true);
    }

    private void buildActions() {
        miDefault.addActionListener(listener);
        miBlack.addActionListener(listener);
        miBlueprint.addActionListener(listener);
        miDark.addActionListener(listener);
        miEclipse.addActionListener(listener);
        miIdea.addActionListener(listener);
        miVS.addActionListener(listener);
    }

    private MenuListener menuListener = new MenuListener() {

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            String name = multiTextComponent.getMultiTextOptions().getThemeFileName();
            if (name.equals("neutrino/assets/default.xml")) {
                buttonGroup.setSelected(miDefault.getModel(), true);
            } else if (name.equals("neutrino/assets/blueprint.xml")) {
                buttonGroup.setSelected(miBlueprint.getModel(), true);
            } else if (name.equals("neutrino/assets/black.xml")) {
                buttonGroup.setSelected(miBlack.getModel(), true);
            } else if (name.equals("neutrino/assets/dark.xml")) {
                buttonGroup.setSelected(miDark.getModel(), true);
            } else if (name.equals("neutrino/assets/eclipse.xml")) {
                buttonGroup.setSelected(miEclipse.getModel(), true);
            } else if (name.equals("neutrino/assets/idea.xml")) {
                buttonGroup.setSelected(miIdea.getModel(), true);
            } else if (name.equals("neutrino/assets/vs.xml")) {
                buttonGroup.setSelected(miVS.getModel(), true);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) { }

        @Override
        public void menuCanceled(MenuEvent menuEvent) { }

    };

    private ActionListener listener = new ActionListener() {

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == miDefault) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/default.xml");
            } else if (actionEvent.getSource() == miBlack) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/black.xml");
            } else if (actionEvent.getSource() == miBlueprint) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/blueprint.xml");
            } else if (actionEvent.getSource() == miDark) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/dark.xml");
            } else if (actionEvent.getSource() == miEclipse) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/eclipse.xml");
            } else if (actionEvent.getSource() == miIdea) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/idea.xml");
            } else if (actionEvent.getSource() == miVS) {
                multiTextComponent.getMultiTextOptions().setTheme("neutrino/assets/vs.xml");
            }

        }

    };

    public static JMenu createThemeMenu(MultiTextComponent multiTextComponent) {
        ThemeChooser chooser = new ThemeChooser(multiTextComponent);
        return chooser.menu;
    }

}
