package neutrino.multitext;

import java.util.ArrayList;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 11/30/15
 * Time: 4:27 AM
 */
public interface BookmarkSupport {

    /**
     * Sets whether the line numbers is visible in the text editor adapter
     * @param value - boolean
     */
    public void setLineNumbersEnabled(boolean value);

    /**
     * Returns true when the line numbers is visible in the text editor adapter
     * @return boolean
     */
    public boolean isLineNumbersEnabled();

    /**
     * Sets whether the bookmark is enabled in the text editor adapter
     * @param value - boolean
     */
    public void setBookmarksEnabled(boolean value);

    /**
     * Returns true when the bookmark is enabled in the text editor adapter
     * @return boolean
     */
    public boolean isBookmarksEnabled();

    /**
     * Toggles the bookmark at the caret position
     */
    public void toggleBookmark();

    /**
     * Returns true when exists the bookmark before the caret position
     * @return boolean
     */
    public boolean hasPreviousBookmark();

    /**
     * Places the cursor at the previous bookmark to the cursor position
     */
    public void previousBookmark();

    /**
     * Returns true when exists the bookmark next to the caret position
     * @return boolean
     */
    public boolean hasNextBookmark();

    /**
     * Places the cursor at the next bookmark to the cursor position
     */
    public void nextBookmark();

    /**
     * Returns true when in the line where the cursor is placed the bookmark
     * @return boolean
     */
    public boolean canRemoveBookmark();

    /**
     * Removes the bookmark at the current line
     */
    public void removeBookmark();

    /**
     * Adds the named bookmark in the caret position. Asks fo a name in the dialog
     */
    public void addNamedBookmark();

    /**
     * Returns true when the document contains a bookmarks
     * @return boolean
     */
    public boolean canRemoveAllBookmarks();

    /**
     * Removes all bookmarks
     */
    public void removeAllBookmarks();

    /**
     * Returns the array of bookmarks
     * @return array list of BookmarkInformation
     */
    public ArrayList<BookmarkInformation> getBookmarks();

    /**
     * Returns true when the editor has a bookmarks
     * @return boolean
     */
    public boolean hasBookmarks();

    /**
     * Returns the array of named bookmarks
     * @return array list of BookmarkInformation
     */
    public ArrayList<BookmarkInformation> getNamedBookmarks();

    /**
     * Returns true when the editor has a named bookmarks
     * @return boolean
     */
    public boolean hasNamedBookmarks();

    /**
     * Sets the bookmarks
     * @param bookmarks ArrayList of BookmarkInformation
     */
    public void setBookmarks(ArrayList<BookmarkInformation> bookmarks);

}
