package neutrino.multitext;

import neutrino.text.TextEditor;
import java.io.File;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 11/30/15
 * Time: 5:28 AM
 */
public interface NavigationSupport {


    /**
     * Activates tab with given text editor
     * @param textEditor - a text component
     */
    public void activateTab(TextEditor textEditor);

    /**
     * Activates tab with given file
     * @param file - a File
     */
    public void activateTab(File file);

    /**
     * Returns true when the file is opened by multi text component
     * @param file - File
     * @return boolean
     */
    public boolean canActivate(File file);

    /**
     * Returns true when other text editor can be activated
     * @return boolean
     */
    public boolean canActivate();

    /**
     * Returns true when the previous to current text editor can be activated
     * @return boolean
     */
    public boolean canActivatePrevious();

    /**
     * Activates the previous to current text editor
     */
    public void activatePrevious();

    /**
     * Returns true when the next to current text editor can be activated
     * @return boolean
     */
    public boolean canActivateNext();

    /**
     * Activates the next to current text editor
     */
    public void activateNext();

    /**
     * Returns true when some editor with modified text exists
     * @return boolean
     */
    public boolean canActivateModified();

    /**
     * Activates first editor with modified text
     */
    public void activateModified();

    /**
     * Returns true when exists the editor with no loaded file
     * @return boolean
     */
    public boolean canActivateUnloaded();

    /**
     * Activates first editor without loaded file
     */
    public void activateUnloaded();

    /**
     * Returns true when exists the editor with changed file
     * @return boolean
     */
    public boolean canActivateReplaced();

    /**
     * Activates first editor with changed file
     */
    public void activateReplaced();

    /**
     * Returns true when the current text editor can be moved to the left
     * @return  boolean
     */
    public boolean canMoveLeft();

    /**
     * Moves the current text component on the one position to the left in the tabbed  panel
     */
    public void moveLeft();

    /**
     * Returns true when the current text editor can be moved to the right
     * @return  boolean
     */
    public boolean canMoveRight();

    /**
     * Moves the current text component on the one position to the right in the tabbed  panel
     */
    public void moveRight();

}
