package neutrino.multitext;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Encapsulates the information about the editing session
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 11/22/15
 * Time: 4:43 AM
 */
public class Session implements Serializable {

    private static final String defaultName = "noname";
    private String name = null;
    private ArrayList<TextInfo> texts = null;

    public Session() {
        setName(defaultName);
        setTexts(new ArrayList<TextInfo>());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        if (name == null) return;
        this.name = name;
    }

    public boolean isNamed() {
        return !name.equals(defaultName);
    }

    public ArrayList<TextInfo> getTexts() {
        return texts;
    }

    public void setTexts(ArrayList<TextInfo> texts) {
        if (texts == null) return;
        this.texts = texts;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Session)) return false;
        return ((Session) object).getName().equals(name);
    }

}
