package neutrino.options;

import com.inet.jortho.SpellChecker;
import neutrino.dialogs.SpellingOptionsChooser;
import neutrino.multitext.MultiTextComponent;
import javax.swing.text.JTextComponent;
import java.io.Serializable;
import java.util.Locale;

/**
 * Contains spelling options for persisting using object stream
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class SpellingOptions implements Serializable {

    private Locale spellLanguage;
    private int menuLimit;
    private int dialogLimit;
    private boolean autoSpellingMode;
    private boolean caseSensitive;
    private boolean ignoreAllCapsWords;
    private boolean ignoreCapitalization;
    private boolean ignoreWordsWithNumbers;

    public SpellingOptions() {
        spellLanguage = SpellChecker.getCurrentLocale();
        menuLimit = 15;
        dialogLimit = 40;
        autoSpellingMode = true;
        caseSensitive = true;
        ignoreAllCapsWords = true;
        ignoreCapitalization = true;
        ignoreWordsWithNumbers = true;
    }

    /**
     * Establishes the properties.
     */
    public void buildProperties() {
        spellLanguage = SpellChecker.getCurrentLocale();
        menuLimit = SpellChecker.getOptions().getSuggestionsLimitMenu();
        dialogLimit = SpellChecker.getOptions().getSuggestionsLimitDialog();
        autoSpellingMode = SpellingOptionsChooser.isAutoSpellingMode();
        caseSensitive = SpellChecker.getOptions().isCaseSensitive();
        ignoreAllCapsWords = SpellChecker.getOptions().isIgnoreAllCapsWords();
        ignoreCapitalization = SpellChecker.getOptions().getIgnoreCapitalization();
        ignoreWordsWithNumbers = SpellChecker.getOptions().isIgnoreWordsWithNumbers();
    }

    /**
     * Sets the values of properties.
     */
    public void establishProperties(JTextComponent textComponent, MultiTextComponent multiTextComponent) {
        if (spellLanguage != null) SpellChecker.setCurrentLocale(spellLanguage);
        SpellChecker.getOptions().setSuggestionsLimitMenu(menuLimit);
        SpellChecker.getOptions().setSuggestionsLimitDialog(dialogLimit);
        SpellingOptionsChooser.setAutoSpellingMode(autoSpellingMode);
        if (textComponent != null) SpellChecker.enableAutoSpell(textComponent, autoSpellingMode);
        if (multiTextComponent != null) multiTextComponent.getMultiTextOptions().enableAutoSpell(autoSpellingMode);
        SpellChecker.getOptions().setCaseSensitive(caseSensitive);
        SpellChecker.getOptions().setIgnoreAllCapsWords(ignoreAllCapsWords);
        SpellChecker.getOptions().setIgnoreCapitalization(ignoreCapitalization);
        SpellChecker.getOptions().setIgnoreWordsWithNumbers(ignoreWordsWithNumbers);
    }

}
