package commands;

import gui.Application;
import neutrino.dialogs.ComplexOperationChooser;
import neutrino.text.IPlainTextComponent;
import neutrino.text.ITextComponent;
import javax.swing.text.JTextComponent;

/**
 * Gateway to advanced editing commands.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
class CommandCommandGateway implements ICommandGateway {

	private Application application = null;
	
	public CommandCommandGateway(Application application) {
		this.application = application;
	}

    /**
     * Performs command appropriate to given type
     * @param command - CommandType
     */
    public void performCommand(CommandType command) {
        switch (command) {
            case MAKE_UPPER_CASE:
                makeUpperCase();
                break;
            case MAKE_LOWER_CASE:
                makeLowerCase();
                break;
            case MAKE_TITLE_CASE:
                makeTitleCase();
                break;
            case CAPITALIZE_WORDS:
                capitalize();
                break;
            case INVERT_CASE_LETTERS:
                invertCase();
                break;
            case INVERT_CAPITALIZATION:
                invertCapitalization();
                break;
            case TABIFY_SELECTED_LINES:
                tabifySelectedLines();
                break;
            case UNTABIFY_SELECTED_LINES:
                untabifySelectedLines();
                break;
            case TRIM_SELECTED_LINES:
                trimSelectedLines();
                break;
            case JOIN_SELECTED_LINES:
                joinSelectedLines();
                break;
            case SPLIT_INTO_LINES:
                splitIntoLines();
                break;
            case DUPLICATE_SELECTED_LINES:
                duplicateSelectedLines();
                break;
            case REMOVE_EMPTY_LIENS:
                removeEmptyLines();
                break;
            case SORT_LINES_ASCENDANT:
                sortLinesAscendant();
                break;
            case SORT_LINES_DESCENDANT:
                sortLinesDescendant();
                break;
            case DELETE_HORIZONTAL_WHITE_SPACE:
                deleteHorizontalWhiteSpace();
                break;
            case REMOVE_TRAILING_WHITESPACES:
                removeTrailingWhitespaces();
                break;
            case INCREASE_LINE_INDENT:
                shiftInRight();
                break;
            case DECREASE_LINE_INDENT:
                shiftInLeft();
                break;
            case MOVE_LINES_UP:
                moveLinesUp();
                break;
            case MOVE_LINES_DOWN:
                moveLinesDown();
                break;
            case ALIGN_TEXT_LEFT:
                alignTextLeft();
                break;
            case ALIGN_TEXT_RIGHT:
                alignTextRight();
                break;
            case CENTER_TEXT:
                centerText();
                break;
            case JUSTIFY_TEXT:
                justifyText();
                break;
            case MAKE_LATIN_PARAGRAPH:
                makeLatinParagraph();
                break;
            case MAKE_CYRILLIC_PARAGRAPH:
                makeCyrillicParagraph();
                break;
            case PERFORM_COMPLEX_OPERATION:
                performComplexOperation();
                break;
        }
    }

    /**
     * Returns true when the command gateway contains the command
     * @param command - CommandType
     * @return - boolean
     */
    public boolean containsCommand(CommandType command) {
        switch (command) {
            case MAKE_UPPER_CASE:
            case MAKE_LOWER_CASE:
            case MAKE_TITLE_CASE:
            case CAPITALIZE_WORDS:
            case INVERT_CASE_LETTERS:
            case INVERT_CAPITALIZATION:
            case TABIFY_SELECTED_LINES:
            case UNTABIFY_SELECTED_LINES:
            case TRIM_SELECTED_LINES:
            case JOIN_SELECTED_LINES:
            case SPLIT_INTO_LINES:
            case DUPLICATE_SELECTED_LINES:
            case REMOVE_EMPTY_LIENS:
            case SORT_LINES_ASCENDANT:
            case SORT_LINES_DESCENDANT:
            case DELETE_HORIZONTAL_WHITE_SPACE:
            case REMOVE_TRAILING_WHITESPACES:
            case INCREASE_LINE_INDENT:
            case DECREASE_LINE_INDENT:
            case MOVE_LINES_UP:
            case MOVE_LINES_DOWN:
            case ALIGN_TEXT_LEFT:
            case ALIGN_TEXT_RIGHT:
            case CENTER_TEXT:
            case JUSTIFY_TEXT:
            case MAKE_LATIN_PARAGRAPH:
            case MAKE_CYRILLIC_PARAGRAPH:
            case PERFORM_COMPLEX_OPERATION:
                return true;
            default:
                return false;
        }
    }

    /**
     * Returns true when can perform command appropriate to given type
     * @param command - CommandType
     * @return boolean
     */
    public boolean canPerformCommand(CommandType command) {
        switch (command) {
            case MAKE_UPPER_CASE:
                return canMakeUpperCase();
            case MAKE_LOWER_CASE:
                return canMakeLowerCase();
            case MAKE_TITLE_CASE:
                return canMakeTitleCase();
            case CAPITALIZE_WORDS:
                return canCapitalize();
            case INVERT_CASE_LETTERS:
                return canInvertCase();
            case INVERT_CAPITALIZATION:
                return canInvertCapitalization();
            case TABIFY_SELECTED_LINES:
                return canTabifySelectedLines();
            case UNTABIFY_SELECTED_LINES:
                return canUntabifySelectedLines();
            case TRIM_SELECTED_LINES:
                return canTrimSelectedLines();
            case JOIN_SELECTED_LINES:
                return canJoinSelectedLines();
            case SPLIT_INTO_LINES:
                return canSplitIntoLines();
            case DUPLICATE_SELECTED_LINES:
                return canDuplicateSelectedLines();
            case REMOVE_EMPTY_LIENS:
                return canRemoveEmptyLines();
            case SORT_LINES_ASCENDANT:
                return canSortLinesAscendant();
            case SORT_LINES_DESCENDANT:
                return canSortLinesDescendant();
            case DELETE_HORIZONTAL_WHITE_SPACE:
                return canDeleteHorizontalWhiteSpace();
            case REMOVE_TRAILING_WHITESPACES:
                return canRemoveTrailingWhitespaces();
            case INCREASE_LINE_INDENT:
                return canIncreaseLineIndent();
            case DECREASE_LINE_INDENT:
                return canDecreaseLineIndent();
            case MOVE_LINES_UP:
                return canMoveLinesUp();
            case MOVE_LINES_DOWN:
                return canMoveLinesDown();
            case ALIGN_TEXT_LEFT:
                return canAlignTextLeft();
            case ALIGN_TEXT_RIGHT:
                return canAlignTextRight();
            case CENTER_TEXT:
                return canCenterText();
            case JUSTIFY_TEXT:
                return canJustifyText();
            case MAKE_LATIN_PARAGRAPH:
                return canMakeLatinParagraph();
            case MAKE_CYRILLIC_PARAGRAPH:
                return canMakeCyrillicParagraph();
            case PERFORM_COMPLEX_OPERATION:
                return canPerformComplexOperation();
            default:
                return true;
        }
    }

    private boolean canMakeUpperCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMakeUpperCase();
        } else {
            return false;
        }
    }

	private void makeUpperCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).makeUpperCase();
	}

    private boolean canMakeLowerCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMakeLowerCase();
        } else {
            return false;
        }
    }

    private void makeLowerCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).makeLowerCase();
	}

    private boolean canMakeTitleCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMakeTitleCase();
        } else {
            return false;
        }
    }

    private void makeTitleCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).makeTitleCase();
    }

    private boolean canCapitalize() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canCapitalize();
        } else {
            return false;
        }
    }

    private void capitalize() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).capitalize();
    }

    private boolean canInvertCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canInvertCase();
        } else {
            return false;
        }
    }

    private void invertCase() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).invertCase();
    }

    private boolean canInvertCapitalization() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canInvertCapitalization();
        } else {
            return false;
        }
    }

    private void invertCapitalization() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).invertCapitalization();
    }

    private boolean canTabifySelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canTabifySelectedLines();
        } else {
            return false;
        }
    }

    private void tabifySelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).tabifySelectedLines();
	}

    private boolean canUntabifySelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canUntabifySelectedLines();
        } else {
            return false;
        }
    }

    private void untabifySelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).untabifySelectedLines();
	}

    private boolean canTrimSelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canTrimSelectedLines();
        } else {
            return false;
        }
    }

    private void trimSelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).trimSelectedLines();
    }

    private boolean canJoinSelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canJoinSelectedLines();
        } else {
            return false;
        }
    }

    private void joinSelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).joinSelectedLines();
    }

    private boolean canSplitIntoLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canSplitIntoLines();
        } else {
            return false;
        }
    }

    private void splitIntoLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).splitIntoLines();
    }

    private boolean canDuplicateSelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canDuplicateSelectedLines();
        } else {
            return false;
        }
    }

    private void duplicateSelectedLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).duplicateSelectedLines();
    }

    private boolean canRemoveEmptyLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canRemoveEmptyLines();
        } else {
            return false;
        }
    }

    private void removeEmptyLines() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).removeEmptyLines();
    }

    private boolean canSortLinesAscendant() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canSortLinesAscendant();
        } else {
            return false;
        }
    }

    private void sortLinesAscendant() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).sortLinesAscendant();
    }

    private boolean canSortLinesDescendant() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canSortLinesDescendant();
        } else {
            return false;
        }
    }

    private void sortLinesDescendant() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).sortLinesDescendant();
    }

    private boolean canDeleteHorizontalWhiteSpace() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canDeleteHorizontalWhiteSpace();
        } else {
            return false;
        }
    }

    private void deleteHorizontalWhiteSpace() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).deleteHorizontalWhiteSpace();
	}

    private boolean canRemoveTrailingWhitespaces() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canRemoveTrailingWhitespaces();
        } else {
            return false;
        }
    }

    private void removeTrailingWhitespaces() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).removeTrailingWhitespaces();
	}

    private boolean canDecreaseLineIndent() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canShiftInLeft();
        } else {
            return false;
        }
    }

    private void shiftInLeft() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).shiftInLeft();
	}

    private boolean canIncreaseLineIndent() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return ((IPlainTextComponent) textComponent).canShiftInRight();
        } else {
            return false;
        }
    }

    private void shiftInRight() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).shiftInRight();
	}

    private boolean canMoveLinesUp() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMoveLinesUp();
        } else {
            return false;
        }
    }

    private void moveLinesUp() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).moveLinesUp();
    }

    private boolean canMoveLinesDown() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMoveLinesDown();
        } else {
            return false;
        }
    }

    private void moveLinesDown() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).moveLinesDown();
    }

    private boolean canAlignTextLeft() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canAlignTextLeft();
        } else {
            return false;
        }
    }

    private void alignTextLeft() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).alignTextLeft();
    }

    private boolean canAlignTextRight() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canAlignTextRight();
        } else {
            return false;
        }
    }

    private void alignTextRight() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).alignTextRight();
    }

    private boolean canCenterText() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canCenterText();
        } else {
            return false;
        }
    }

    private void centerText() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).centerText();
    }

    private boolean canJustifyText() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canJustifyText();
        } else {
            return false;
        }
    }

    private void justifyText() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).justifyText();
    }

    private boolean canMakeLatinParagraph() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMakeLatinParagraph();
        } else {
            return false;
        }
    }

    private void makeLatinParagraph() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).makeLatinParagraph();
    }

    private boolean canMakeCyrillicParagraph() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent) textComponent).canMakeCyrillicParagraph();
        } else {
            return false;
        }
    }

    private void makeCyrillicParagraph() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof IPlainTextComponent) ((IPlainTextComponent) textComponent).makeCyrillicParagraph();
    }

    private boolean canPerformComplexOperation() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            return !((ITextComponent) textComponent).isTextEmpty();
        } else {
            return false;
        }
    }

    private void performComplexOperation() {
		ComplexOperationChooser.showComplexOperationDialog(application, application.getTextEditor().getTextComponent());
	}

}
