package commands;

import game.rally.Game;
import gui.Application;
import gui.dialog.AboutDialog;
import neutrino.dialogs.LicenseChooser;

import javax.swing.*;
import java.io.File;

/**
 * Gateway to help commands
 * Date: 8/1/16
 * Time: 12:55 AM
 * @author Oleh Radvanskyj
 * @version 2.7
 */
public class HelpCommandGateway implements ICommandGateway {

    private Application application = null;
    private final String LICENSE_FILE_NAME = "license.txt";

    public HelpCommandGateway(Application application) {
        this.application = application;
    }

    /**
     * Performs command appropriate to given type
     * @param command - CommandType
     */
    public void performCommand(CommandType command) {
        switch (command) {
            case GAME:
                playRally();
                break;
            case LICENSE:
                showLicense();
                break;
            case ABOUT:
                about();
                break;
        }
    }

    /**
     * Returns true when the command gateway contains the command
     * @param command - CommandType
     * @return - boolean
     */
    public boolean containsCommand(CommandType command) {
        switch (command) {
            case GAME:
            case LICENSE:
            case ABOUT:
                return true;
            default:
                return false;
        }
    }

    /**
     * Returns true when can perform command appropriate to given type
     * @param command - CommandType
     * @return boolean
     */
    public boolean canPerformCommand(CommandType command) {
        switch (command) {
            default:
                return true;
        }
    }

    private void playRally() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                Game.main(null);
            }
        });
    }

    private void showLicense() {
        LicenseChooser.showLicenseDialog(application, new File(LICENSE_FILE_NAME));
    }

    private void about() {
        AboutDialog.showAboutDialog(application);
    }

}
